/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5222;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.client.render.text.WidthLimitedCharSink;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.util.text.AdvancedComponentHelper;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.AdvancedFormattedText;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class CompiledText {
    public static final CompiledText EMPTY = new CompiledText(0, 0){
        {
            this.original = Collections.EMPTY_LIST;
            this.lines = Collections.EMPTY_LIST;
        }

        @Override
        public void setText(class_2561 component) {
        }

        @Override
        public void setText(List<class_2561> components) {
        }

        @Override
        protected void compile() {
        }

        @Override
        public int getTotalHeight() {
            return 0;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void render(class_332 graphics) {
        }
    };
    private int maxWidth;
    private int maxWidthScaled;
    private int maxHeight;
    private int maxHeightScaled;
    private int usedWidth;
    private int usedHeight;
    private int lineSpacing = 2;
    private boolean shadow = true;
    private int defaultColor = -1;
    private Align align = Align.LEFT;
    private VAlign valign = VAlign.TOP;
    protected List<CompiledLine> lines;
    protected List<class_2561> original;
    private double scale = 1.0;

    private static int width(class_5348 text) {
        if (text instanceof AdvancedFormattedText) {
            AdvancedFormattedText adv = (AdvancedFormattedText)text;
            return adv.width(AdvancedComponentHelper.SPLITTER.width, class_2583.field_24360);
        }
        return class_3532.method_15386((float)AdvancedComponentHelper.SPLITTER.method_27488(text));
    }

    private static int lineHeight(class_5348 text) {
        class_2561 comp;
        class_7417 class_74172;
        if (text instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)text;
            return adv.height();
        }
        if (text instanceof class_2561 && (class_74172 = (comp = (class_2561)text).method_10851()) instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)class_74172;
            return adv.height();
        }
        return AdvancedComponentHelper.SPLITTER.lineHeight;
    }

    public CompiledText(int width, int height) {
        this.maxWidth = this.maxWidthScaled = width;
        this.maxHeight = this.maxHeightScaled = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
        this.maxHeightScaled = (int)((double)this.maxHeight * this.scale);
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxWidthScaled = (int)((double)this.maxWidth / this.scale);
        this.maxHeight = height;
        this.maxHeightScaled = (int)((double)this.maxHeight / this.scale);
        this.compile();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setDefaultColor(int color) {
        this.defaultColor = color;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setVAlign(VAlign valign) {
        this.valign = valign;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.maxWidthScaled = (int)((double)this.maxWidth / scale);
        this.maxHeightScaled = (int)((double)this.maxHeight / scale);
        this.compile();
    }

    public double getScale() {
        return this.scale;
    }

    public void setText(class_2561 component) {
        this.setText(new SingletonList<class_2561>(component));
    }

    public void setText(List<class_2561> components) {
        this.original = components;
        this.compile();
    }

    protected void compile() {
        if (CreativeCore.loader().getOverallSide().isServer()) {
            return;
        }
        ArrayList<class_2561> copy = new ArrayList<class_2561>();
        for (class_2561 component : this.original) {
            copy.add(AdvancedComponentHelper.copy(component));
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, class_53482);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, class_5348 component) {
        if (newLine) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
        }
        return this.compileNext(currentLine, component);
    }

    private CompiledLine compileNext(CompiledLine currentLine, class_5348 component) {
        class_5348 next;
        ArrayList siblings = null;
        if (component instanceof class_2561 && !((class_2561)component).method_10855().isEmpty()) {
            siblings = new ArrayList(((class_2561)component).method_10855());
            ((class_2561)component).method_10855().clear();
        }
        if ((next = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, next);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return class_3532.method_15384((double)((double)height * this.scale));
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_332 graphics) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        int totalHeight = this.getTotalHeight();
        class_4587 stack = graphics.method_51448();
        if (this.scale != 1.0) {
            stack.method_22903();
            stack.method_22905((float)this.scale, (float)this.scale, 1.0f);
        }
        stack.method_22903();
        float y = Math.max(0, switch (this.valign) {
            case VAlign.CENTER -> this.maxHeightScaled / 2 - totalHeight / 2;
            case VAlign.BOTTOM -> this.maxHeightScaled - totalHeight;
            default -> 0;
        });
        stack.method_46416(0.0f, y, 0.0f);
        this.usedHeight += (int)y;
        for (CompiledLine line : this.lines) {
            switch (this.align) {
                case CENTER: {
                    int x = this.maxWidthScaled / 2 - line.width / 2;
                    stack.method_46416((float)x, 0.0f, 0.0f);
                    line.render(graphics);
                    stack.method_46416((float)(-x), 0.0f, 0.0f);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidthScaled);
                    break;
                }
                case RIGHT: {
                    int x = this.maxWidthScaled - line.width;
                    stack.method_46416((float)x, 0.0f, 0.0f);
                    line.render(graphics);
                    stack.method_46416((float)(-x), 0.0f, 0.0f);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidthScaled);
                    break;
                }
                default: {
                    line.render(graphics);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                }
            }
            int height = line.height + this.lineSpacing;
            stack.method_46416(0.0f, (float)height, 0.0f);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeightScaled) continue;
            break;
        }
        stack.method_22909();
        if (this.scale != 1.0) {
            stack.method_22909();
        }
        RenderSystem.enableBlend();
        this.usedWidth = (int)((double)this.usedWidth * this.scale);
        this.usedHeight = (int)((double)this.usedHeight * this.scale);
    }

    @Environment(value=EnvType.CLIENT)
    public FormattedTextSplit splitByWidth(class_5348 text, int width, class_2583 style, final boolean force) {
        final WidthLimitedCharSink charSink = new WidthLimitedCharSink(width, class_310.method_1551().field_1772.method_27527());
        final class_5222 head = new class_5222();
        final class_5222 tail = new class_5222();
        if (text instanceof class_2561) {
            class_2561 comp = (class_2561)text;
            AdvancedComponentHelper.visit(comp, new AdvancedContentConsumer(){

                public Optional accept(class_2583 style, AdvancedContent content) {
                    if (charSink.accept(style, content) || force) {
                        head.method_27462(content.asText());
                    } else {
                        tail.method_27462(content.asText());
                    }
                    return Optional.empty();
                }

                public Optional accept(class_2583 style, String text) {
                    charSink.resetPosition();
                    if (!class_5223.method_27479((String)text, (class_2583)style, (class_5224)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.method_27462(class_5348.method_29431((String)sHead, (class_2583)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.method_27462(class_5348.method_29431((String)sTail, (class_2583)style));
                            }
                        } else {
                            tail.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                    }
                    return Optional.empty();
                }
            }, style);
        } else {
            text.method_27658((class_5348.class_5246)new class_5348.class_5246<class_5348>(){

                public Optional<class_5348> accept(class_2583 style, String text) {
                    charSink.resetPosition();
                    if (!class_5223.method_27479((String)text, (class_2583)style, (class_5224)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.method_27462(class_5348.method_29431((String)sHead, (class_2583)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.method_27462(class_5348.method_29431((String)sTail, (class_2583)style));
                            }
                        } else {
                            tail.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                    }
                    return Optional.empty();
                }
            }, style);
        }
        class_5348 headText = head.method_27461();
        class_5348 tailText = tail.method_27461();
        if (headText == null && tailText == null) {
            return null;
        }
        return new FormattedTextSplit(headText, tailText);
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalWidth() {
        return class_3532.method_15384((double)((double)this.calculateWidth(0, true, this.original) * this.scale));
    }

    @Environment(value=EnvType.CLIENT)
    private int calculateWidth(int width, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            int result = CompiledText.width(class_53482);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    public CompiledText copy() {
        CompiledText copy = new CompiledText(this.maxWidth, this.maxHeight);
        copy.align = this.align;
        copy.valign = this.valign;
        copy.defaultColor = this.defaultColor;
        copy.lineSpacing = this.lineSpacing;
        copy.shadow = this.shadow;
        copy.scale = this.scale;
        copy.maxWidthScaled = this.maxWidthScaled;
        copy.maxHeightScaled = this.maxHeightScaled;
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        for (class_2561 component : this.original) {
            components.add((class_2561)component.method_27661());
        }
        copy.setText(components);
        return copy;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean contains(String search) {
        for (CompiledLine line : this.lines) {
            if (!line.contains(search)) continue;
            return true;
        }
        return false;
    }

    public int getUsedWidth() {
        return this.usedWidth;
    }

    public int getUsedHeight() {
        return this.usedHeight;
    }

    public Iterable<class_2561> untrimmedContent() {
        return this.original;
    }

    public class CompiledLine {
        private final List<class_5348> components = new ArrayList<class_5348>();
        private int height = 0;
        private int width = 0;

        public boolean contains(String search) {
            for (class_5348 text : this.components) {
                if (!text.getString().contains(search)) continue;
                return true;
            }
            return false;
        }

        @Environment(value=EnvType.CLIENT)
        public void render(class_332 graphics) {
            class_327 font = class_310.method_1551().field_1772;
            int xOffset = 0;
            class_4587 pose = graphics.method_51448();
            class_4597.class_4598 bufferSource = graphics.method_51450();
            for (class_5348 text : this.components) {
                int height = CompiledText.lineHeight(text);
                int width = CompiledText.width(text);
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                pose.method_22903();
                pose.method_46416((float)xOffset, (float)yOffset, 0.0f);
                if (text instanceof AdvancedFormattedText) {
                    AdvancedFormattedText adv = (AdvancedFormattedText)text;
                    adv.render(graphics, CompiledText.this.defaultColor);
                } else {
                    font.method_22942(class_2477.method_10517().method_30934(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, pose.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                    bufferSource.method_22993();
                }
                pose.method_22909();
                xOffset += width;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public class_5348 add(class_5348 component) {
            int remainingWidth = CompiledText.this.maxWidthScaled - this.width;
            int textWidth = CompiledText.width(component);
            if (remainingWidth >= textWidth) {
                class_2561 comp;
                class_7417 class_74172;
                if (component instanceof class_2561 && (class_74172 = (comp = (class_2561)component).method_10851()) instanceof AdvancedContent) {
                    AdvancedContent adv = (AdvancedContent)class_74172;
                    this.components.add(adv.asText());
                } else {
                    this.components.add(component);
                }
                this.updateDimension(this.width + textWidth, CompiledText.lineHeight(component));
                return null;
            }
            FormattedTextSplit split = CompiledText.this.splitByWidth(component, remainingWidth, class_2583.field_24360, this.width == 0);
            if (split != null && (split.head != null || this.width == 0)) {
                if (split.head != null) {
                    this.updateDimension(this.width + CompiledText.width(split.head), CompiledText.lineHeight(split.head));
                    this.components.add(split.head);
                    return split.tail;
                }
                this.updateDimension(this.width + CompiledText.width(split.tail), CompiledText.lineHeight(split.tail));
                this.components.add(split.tail);
                return null;
            }
            if (this.width == 0) {
                return null;
            }
            return component;
        }
    }

    public record FormattedTextSplit(class_5348 head, class_5348 tail) {
    }
}

