/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@Environment(value=EnvType.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", gui.getPlayer(), new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add((GuiControl)selector);
                gui.add((GuiControl)new GuiLabel("guilabel1"));
                gui.add((GuiControl)new GuiLabel("guilabel2"));
                GuiStateButton damage = new GuiStateButton("damage", 0, new TextListBuilder().add("Damage: Off", "Damage: On"));
                gui.add((GuiControl)damage);
                GuiStateButton nbt = new GuiStateButton("nbt", 0, new TextListBuilder().add("NBT: Off", "NBT: On"));
                gui.add((GuiControl)nbt);
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().method_7972());
                    if (info instanceof CreativeIngredientItemStack) {
                        damage.nextState();
                        if (((CreativeIngredientItemStack)info).needNBT) {
                            nbt.nextState();
                        }
                    }
                }
                this.onChanged(gui, new GuiControlChangedEvent<GuiStackSelector>(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                class_1799 stack = ((GuiStackSelector)gui.get("inv")).getSelected();
                if (stack != null) {
                    boolean nbt;
                    boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                    boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                    if (damage) {
                        return new CreativeIngredientItemStack(stack.method_7972(), nbt);
                    }
                    if (!(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2189)) {
                        return new CreativeIngredientBlock(class_2248.method_9503((class_1792)stack.method_7909()));
                    }
                    return new CreativeIngredientItem(stack.method_7909());
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiControl guiControl;
                if (event.control.is("inv") && (guiControl = event.control) instanceof GuiStackSelector) {
                    GuiStackSelector selector = (GuiStackSelector)guiControl;
                    class_1799 stack = selector.getSelected();
                    if (!stack.method_7960()) {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((class_2561)class_2561.method_43470((String)("damage: " + stack.method_7919())));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((class_2561)class_2561.method_43470((String)("nbt: " + stack.method_7969())));
                    } else {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((class_2561)class_2561.method_43470((String)""));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((class_2561)class_2561.method_43470((String)""));
                    }
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                class_6862 tag = (class_6862)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((class_6862<class_2248>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<class_6862> box = new GuiComboBoxMapped<class_6862>("tag", new TextMapBuilder<class_6862>().addComponents(class_7923.field_41175.method_40273().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = class_7923.field_41175.method_40266(x);
                    if (tag.isPresent() && ((class_6885.class_6888)tag.get()).method_40247() > 0) {
                        builder.stack(new class_1799((class_1935)((class_6885.class_6888)tag.get()).method_40240(0).comp_349()));
                    }
                    return builder.text(x.comp_327().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(class_7923.field_41175.method_40273().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = class_7923.field_41175.method_40266(x);
                        if (tag.isPresent() && ((class_6885.class_6888)tag.get()).method_40247() > 0) {
                            builder.stack(new class_1799((class_1935)((class_6885.class_6888)tag.get()).method_40240(0).comp_349()));
                        }
                        return builder.text(x.comp_327().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                class_6862 tag = (class_6862)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((class_6862<class_1792>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<class_6862> box = new GuiComboBoxMapped<class_6862>("tag", new TextMapBuilder<class_6862>().addComponents(class_7923.field_41178.method_40273().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = class_7923.field_41178.method_40266(x);
                    if (tag.isPresent() && ((class_6885.class_6888)tag.get()).method_40247() > 0) {
                        builder.stack(new class_1799((class_1935)((class_6885.class_6888)tag.get()).method_40240(0).comp_349()));
                    }
                    return builder.text(x.comp_327().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(class_7923.field_41178.method_40273().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = class_7923.field_41178.method_40266(x);
                        if (tag.isPresent() && ((class_6885.class_6888)tag.get()).method_40247() > 0) {
                            builder.stack(new class_1799((class_1935)((class_6885.class_6888)tag.get()).method_40240(0).comp_349()));
                        }
                        return builder.text(x.comp_327().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add((GuiControl)new GuiLabel("info").setTitle((class_2561)class_2561.method_43470((String)"Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }
}

