/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.vertexAttribute;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import org.lwjgl.opengl.GL43;

public final class VertexAttributePostGL43
extends AbstractVertexAttribute {
    private static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logRendererGLEventToFile).chatLevelConfig(Config.Common.Logging.logRendererGLEventToChat).build();
    int numberOfBindingPoints = 0;
    int strideSize = 0;

    @Override
    public void bindBufferToAllBindingPoints(int buffer) {
        for (int i = 0; i < this.numberOfBindingPoints; ++i) {
            GL43.glBindVertexBuffer((int)i, (int)buffer, (long)0L, (int)this.strideSize);
        }
    }

    @Override
    public void bindBufferToBindingPoint(int buffer, int bindingPoint) {
        GL43.glBindVertexBuffer((int)bindingPoint, (int)buffer, (long)0L, (int)this.strideSize);
    }

    @Override
    public void unbindBuffersFromAllBindingPoint() {
        for (int i = 0; i < this.numberOfBindingPoints; ++i) {
            GL43.glBindVertexBuffer((int)i, (int)0, (long)0L, (int)0);
        }
    }

    @Override
    public void unbindBuffersFromBindingPoint(int bindingPoint) {
        GL43.glBindVertexBuffer((int)bindingPoint, (int)0, (long)0L, (int)0);
    }

    @Override
    public void setVertexAttribute(int bindingPoint, int attributeIndex, VertexPointer attribute) {
        if (attribute.useInteger) {
            GL43.glVertexAttribIFormat((int)attributeIndex, (int)attribute.elementCount, (int)attribute.glType, (int)this.strideSize);
        } else {
            GL43.glVertexAttribFormat((int)attributeIndex, (int)attribute.elementCount, (int)attribute.glType, (boolean)attribute.normalized, (int)this.strideSize);
        }
        this.strideSize += attribute.byteSize;
        if (this.numberOfBindingPoints <= bindingPoint) {
            this.numberOfBindingPoints = bindingPoint + 1;
        }
        GL43.glVertexAttribBinding((int)attributeIndex, (int)bindingPoint);
        GL43.glEnableVertexAttribArray((int)attributeIndex);
    }

    @Override
    public void completeAndCheck(int expectedStrideSize) {
        if (this.strideSize != expectedStrideSize) {
            LOGGER.error("Vertex Attribute calculated stride size " + this.strideSize + " does not match the provided expected stride size " + expectedStrideSize + "!", new Object[0]);
            throw new IllegalArgumentException("Vertex Attribute Incorrect Format");
        }
        LOGGER.info("Vertex Attribute (GL43+) completed. It contains " + this.numberOfBindingPoints + " binding points and a stride size of " + this.strideSize, new Object[0]);
    }
}

