/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BCJDecoder;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.CountingInputStream;
import org.tukaani.xz.DeltaDecoder;
import org.tukaani.xz.FilterCoder;
import org.tukaani.xz.FilterDecoder;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.LZMA2Decoder;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.RawCoder;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;

class BlockInputStream
extends InputStream {
    private final DataInputStream inData;
    private final CountingInputStream inCounted;
    private InputStream filterChain;
    private final Check check;
    private final boolean verifyCheck;
    private long uncompressedSizeInHeader = -1L;
    private long compressedSizeInHeader = -1L;
    private long compressedSizeLimit;
    private final int headerSize;
    private long uncompressedSize = 0L;
    private boolean endReached = false;
    private final byte[] tempBuf = new byte[1];

    public BlockInputStream(InputStream inputStream, Check check, boolean bl, int i, long l, long m, ArrayCache arrayCache) throws IOException, IndexIndicatorException {
        int n;
        long l2;
        int n2;
        this.check = check;
        this.verifyCheck = bl;
        this.inData = new DataInputStream(inputStream);
        int n3 = this.inData.readUnsignedByte();
        if (n3 == 0) {
            throw new IndexIndicatorException();
        }
        this.headerSize = 4 * (n3 + 1);
        byte[] byArray = new byte[this.headerSize];
        byArray[0] = (byte)n3;
        this.inData.readFully(byArray, 1, this.headerSize - 1);
        if (!DecoderUtil.isCRC32Valid(byArray, 0, this.headerSize - 4, this.headerSize - 4)) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        if ((byArray[1] & 0x3C) != 0) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        int n4 = (byArray[1] & 3) + 1;
        long[] lArray = new long[n4];
        byte[][] byArrayArray = new byte[n4][];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 2, this.headerSize - 6);
        try {
            this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
            if ((byArray[1] & 0x40) != 0) {
                this.compressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (this.compressedSizeInHeader == 0L || this.compressedSizeInHeader > this.compressedSizeLimit) {
                    throw new CorruptedInputException();
                }
                this.compressedSizeLimit = this.compressedSizeInHeader;
            }
            if ((byArray[1] & 0x80) != 0) {
                this.uncompressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                lArray[n2] = DecoderUtil.decodeVLI(byteArrayInputStream);
                l2 = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (l2 > (long)byteArrayInputStream.available()) {
                    throw new CorruptedInputException();
                }
                byArrayArray[n2] = new byte[(int)l2];
                byteArrayInputStream.read(byArrayArray[n2]);
            }
        }
        catch (IOException iOException) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        for (n2 = byteArrayInputStream.available(); n2 > 0; --n2) {
            if (byteArrayInputStream.read() == 0) continue;
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        if (l != -1L) {
            n2 = this.headerSize + check.getSize();
            if ((long)n2 >= l) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            l2 = l - (long)n2;
            if (l2 > this.compressedSizeLimit || this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l2) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            if (this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != m) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            this.compressedSizeLimit = l2;
            this.compressedSizeInHeader = l2;
            this.uncompressedSizeInHeader = m;
        }
        FilterCoder[] filterCoderArray = new FilterDecoder[lArray.length];
        for (n = 0; n < filterCoderArray.length; ++n) {
            if (lArray[n] == 33L) {
                filterCoderArray[n] = new LZMA2Decoder(byArrayArray[n]);
                continue;
            }
            if (lArray[n] == 3L) {
                filterCoderArray[n] = new DeltaDecoder(byArrayArray[n]);
                continue;
            }
            if (BCJDecoder.isBCJFilterID(lArray[n])) {
                filterCoderArray[n] = new BCJDecoder(lArray[n], byArrayArray[n]);
                continue;
            }
            throw new UnsupportedOptionsException("Unknown Filter ID " + lArray[n]);
        }
        RawCoder.validate(filterCoderArray);
        if (i >= 0) {
            n = 0;
            for (int j = 0; j < filterCoderArray.length; ++j) {
                n += filterCoderArray[j].getMemoryUsage();
            }
            if (n > i) {
                throw new MemoryLimitException(n, i);
            }
        }
        this.inCounted = new CountingInputStream(inputStream);
        this.filterChain = this.inCounted;
        for (n = filterCoderArray.length - 1; n >= 0; --n) {
            this.filterChain = filterCoderArray[n].getInputStream(this.filterChain, arrayCache);
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bs, int i, int j) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n = this.filterChain.read(bs, i, j);
        if (n > 0) {
            if (this.verifyCheck) {
                this.check.update(bs, i, n);
            }
            this.uncompressedSize += (long)n;
            long l = this.inCounted.getSize();
            if (l < 0L || l > this.compressedSizeLimit || this.uncompressedSize < 0L || this.uncompressedSizeInHeader != -1L && this.uncompressedSize > this.uncompressedSizeInHeader) {
                throw new CorruptedInputException();
            }
            if (n < j || this.uncompressedSize == this.uncompressedSizeInHeader) {
                if (this.filterChain.read() != -1) {
                    throw new CorruptedInputException();
                }
                this.validate();
                this.endReached = true;
            }
        } else if (n == -1) {
            this.validate();
            this.endReached = true;
        }
        return n;
    }

    private void validate() throws IOException {
        long l = this.inCounted.getSize();
        if (this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l || this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != this.uncompressedSize) {
            throw new CorruptedInputException();
        }
        while ((l++ & 3L) != 0L) {
            if (this.inData.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException();
        }
        byte[] byArray = new byte[this.check.getSize()];
        this.inData.readFully(byArray);
        if (this.verifyCheck && !Arrays.equals(this.check.finish(), byArray)) {
            throw new CorruptedInputException("Integrity check (" + this.check.getName() + ") does not match");
        }
    }

    @Override
    public int available() throws IOException {
        return this.filterChain.available();
    }

    @Override
    public void close() {
        block2: {
            try {
                this.filterChain.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.filterChain = null;
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.inCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

