/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric.fabric.config;

import com.fizzware.dramaticdoors.fabric.fabric.config.ModConfigProvider;
import com.fizzware.dramaticdoors.fabric.fabric.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;

public class DDConfigFabric {
    private static ModConfigProvider configProvider;
    public static SimpleConfig CONFIG;
    public static boolean devMode;
    public static boolean waterloggableDoors;
    public static boolean waterloggableFenceGates;

    public static void initializeConfigs() {
        configProvider = new ModConfigProvider();
        DDConfigFabric.createConfigs();
        CONFIG = SimpleConfig.of("dramaticdoors-common").provider(configProvider).request();
        DDConfigFabric.assignConfigs();
    }

    private static void createConfigs() {
        configProvider.addComment("Dramatic Doors");
        configProvider.addCategory("Experimental");
        configProvider.addKeyValuePair(new Pair((Object)"dev_mode", (Object)false), "Development mode ensures that all compat doors are always registered regardless of whether mods are installed or not, for development purposes.");
        configProvider.addNewLine();
        configProvider.addCategory("Mixins");
        configProvider.addKeyValuePair(new Pair((Object)"waterloggable_doors", (Object)true), "Allows doors to be waterlogged. Enable to allow waterlogging, disable for compatibility with certain mods. Currently, this only affects regular doors.  Requires restart after changing.");
        configProvider.addKeyValuePair(new Pair((Object)"waterloggable_fence_gates", (Object)true), "Allows fence gates to be waterlogged. Enable to allow waterlogging, disable for compatibility with certain mods.  Requires restart after changing.");
    }

    private static void assignConfigs() {
        devMode = CONFIG.getOrDefault("dev_mode", false);
        waterloggableDoors = CONFIG.getOrDefault("waterloggable_doors", true);
        waterloggableFenceGates = CONFIG.getOrDefault("waterloggable_fence_gates", true);
    }

    static {
        devMode = false;
        waterloggableDoors = true;
        waterloggableFenceGates = true;
    }
}

