/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.blocks;

import com.fizzware.dramaticdoors.forge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.forge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.forge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TallCreateSlidingDoorBlock
extends TallDoorBlock {
    protected static final VoxelShape SE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)-13.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB = Block.m_49796_((double)-13.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NW_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0);
    protected static final VoxelShape WN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)29.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)-13.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)29.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)29.0);
    protected static final VoxelShape EN_AABB = Block.m_49796_((double)-13.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SE_AABB_FOLD = Block.m_49796_((double)0.0, (double)0.0, (double)-3.0, (double)9.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB_FOLD = Block.m_49796_((double)-3.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NW_AABB_FOLD = Block.m_49796_((double)7.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)19.0);
    protected static final VoxelShape WN_AABB_FOLD = Block.m_49796_((double)13.0, (double)0.0, (double)7.0, (double)19.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB_FOLD = Block.m_49796_((double)7.0, (double)0.0, (double)-3.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB_FOLD = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)19.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NE_AABB_FOLD = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0, (double)19.0);
    protected static final VoxelShape EN_AABB_FOLD = Block.m_49796_((double)-3.0, (double)0.0, (double)7.0, (double)3.0, (double)16.0, (double)16.0);
    public static final BooleanProperty VISIBLE = DDBlockStateProperties.VISIBLE;
    private boolean folds = false;

    public TallCreateSlidingDoorBlock(Block from, BlockSetType blockset, boolean isFolding) {
        super(from, blockset);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DDBlockStateProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.folds = isFolding;
    }

    public static VoxelShape getShapeByProperty(Direction facing, boolean hinge, boolean fold) {
        if (fold) {
            return switch (facing) {
                case Direction.SOUTH -> {
                    if (hinge) {
                        yield ES_AABB_FOLD;
                    }
                    yield WS_AABB_FOLD;
                }
                case Direction.WEST -> {
                    if (hinge) {
                        yield SW_AABB_FOLD;
                    }
                    yield NW_AABB_FOLD;
                }
                case Direction.NORTH -> {
                    if (hinge) {
                        yield WN_AABB_FOLD;
                    }
                    yield EN_AABB_FOLD;
                }
                default -> hinge ? NE_AABB_FOLD : SE_AABB_FOLD;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> {
                if (hinge) {
                    yield ES_AABB;
                }
                yield WS_AABB;
            }
            case Direction.WEST -> {
                if (hinge) {
                    yield SW_AABB;
                }
                yield NW_AABB;
            }
            case Direction.NORTH -> {
                if (hinge) {
                    yield WN_AABB;
                }
                yield EN_AABB;
            }
            default -> hinge ? NE_AABB : SE_AABB;
        };
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockState = super.m_7417_(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
        if (blockState.m_60795_()) {
            return blockState;
        }
        TripleBlockPart part = (TripleBlockPart)((Object)blockState.m_61143_((Property)THIRD));
        if (pFacing.m_122434_() == Direction.Axis.Y && part == TripleBlockPart.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_((Property)THIRD) != part ? (BlockState)blockState.m_61124_((Property)VISIBLE, (Comparable)((Boolean)pFacingState.m_61143_((Property)VISIBLE))) : Blocks.f_50016_.m_49966_();
        }
        if (pFacing.m_122434_() == Direction.Axis.Y && part == TripleBlockPart.UPPER == (pFacing == Direction.DOWN)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_((Property)THIRD) != part ? (BlockState)blockState.m_61124_((Property)VISIBLE, (Comparable)((Boolean)pFacingState.m_61143_((Property)VISIBLE))) : Blocks.f_50016_.m_49966_();
        }
        return blockState;
    }

    @Override
    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.m_60713_((Block)this)) {
            return;
        }
        if ((Boolean)state.m_61143_((Property)OPEN) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.m_7731_(pos, changedState, 10);
        DoorHingeSide hinge = (DoorHingeSide)changedState.m_61143_((Property)HINGE);
        Direction facing = (Direction)changedState.m_61143_((Property)FACING);
        BlockPos otherPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = level.m_8055_(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
            this.setOpen(entity, level, otherDoor, otherPos, open);
        }
        this.playSound(entity, level, pos, open);
        level.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)(state = (BlockState)state.m_61122_((Property)OPEN)).m_61143_((Property)OPEN)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.m_7731_(pos, state, 10);
        level.m_142346_((Entity)player, this.isOpen(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)HINGE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos otherPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = level.m_8055_(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor(state, hinge, facing, otherDoor)) {
            this.m_6227_(otherDoor, level, otherPos, player, hand, hit);
        } else if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_142346_((Entity)player, GameEvent.f_157796_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean isDoubleDoor(BlockState state, DoorHingeSide hinge, Direction facing, BlockState otherDoor) {
        return otherDoor.m_60734_() == state.m_60734_() && otherDoor.m_61143_((Property)HINGE) != hinge && otherDoor.m_61143_((Property)FACING) == facing && otherDoor.m_61143_((Property)OPEN) != state.m_61143_((Property)OPEN) && otherDoor.m_61143_((Property)THIRD) == state.m_61143_((Property)THIRD);
    }

    public static boolean isDoorPowered(Level pLevel, BlockPos pos, BlockState state) {
        boolean lower = state.m_61143_((Property)THIRD) == TripleBlockPart.LOWER;
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)HINGE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos otherPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = pLevel.m_8055_(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor((BlockState)state.m_61122_((Property)OPEN), hinge, facing, otherDoor) && (pLevel.m_276867_(otherPos) || pLevel.m_276867_(otherPos.m_121945_(lower ? Direction.UP : Direction.DOWN)))) {
            return true;
        }
        return pLevel.m_276867_(pos) || pLevel.m_276867_(pos.m_121945_(lower ? Direction.UP : Direction.DOWN));
    }

    public void deferUpdate(LevelAccessor level, BlockPos pos) {
    }

    public boolean isFoldingDoor() {
        return this.folds;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VISIBLE});
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

