/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.mixin;

import com.fizzware.dramaticdoors.forge.compat.DDCompatRecipe;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void interceptApply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo info) {
        DDCompatRecipe.SHORT_DOOR_RECIPES.forEach(recipe -> {
            Object recipeID = recipe.get("result").getAsString();
            if (recipe.get("type").getAsString().contains("aurorasdeco")) {
                recipeID = (String)recipeID + "_aurorasdeco_sawmill";
            } else if (recipe.get("type").getAsString().contains("woodworks")) {
                recipeID = (String)recipeID + "_sawing";
            } else if (recipe.get("type").getAsString().contains("sawmill")) {
                recipeID = (String)recipeID + "_universal_sawmill";
            }
            map.put(new ResourceLocation((String)recipeID), (JsonElement)recipe);
        });
        DDCompatRecipe.TALL_DOOR_RECIPES.forEach(recipe -> map.put(new ResourceLocation(recipe.get("result").getAsJsonObject().get("item").getAsString()), (JsonElement)recipe));
    }
}

