/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.setup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.setup.ModTags;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_4174;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class ModRegistry {
    public static List<class_2248> BLOCKS = new ArrayList<class_2248>();
    public static Map<class_6862<class_2248>, List<class_2248>> BLOCK_TAGS = new HashMap<class_6862<class_2248>, List<class_2248>>();
    public static Map<class_2248, class_1935> BLOCK_DROPS = new HashMap<class_2248, class_1935>();
    public static Map<class_2248, class_2248> BLOCK_STRIPPED = new HashMap<class_2248, class_2248>();
    public static Map<class_2248, Map<Models, class_2248>> BLOCK_SETS = new HashMap<class_2248, Map<Models, class_2248>>();
    public static Map<Models, List<class_2248>> BLOCK_MODELS = new HashMap<Models, List<class_2248>>();
    public static List<class_2248> BLOCK_CUTOUT = new ArrayList<class_2248>();
    public static Map<class_2248, class_3545<Integer, Integer>> BLOCK_FLAMMABLE = new HashMap<class_2248, class_3545<Integer, Integer>>();
    public static List<class_1792> ITEMS = new ArrayList<class_1792>();
    public static Map<class_6862<class_1792>, List<class_1792>> ITEM_TAGS = new HashMap<class_6862<class_1792>, List<class_1792>>();
    public static Map<class_1792, class_4942> ITEM_MODELS = new HashMap<class_1792, class_4942>();
    public static Map<class_1935, Integer> ITEM_BURNABLE = new HashMap<class_1935, Integer>();

    public static BlockBuilder ofBlock(String id, class_2248 block) {
        return ModRegistry.ofBlock(id, block, true);
    }

    public static BlockBuilder ofBlock(String id, class_2248 block, boolean item) {
        return new BlockBuilder(Phantasm.makeID(id), block, item);
    }

    public static ItemBuilder ofItem(String id, class_1792 item) {
        return new ItemBuilder(Phantasm.makeID(id), item);
    }

    public static List<class_2248> getModelList(Models key) {
        return BLOCK_MODELS.getOrDefault((Object)key, new ArrayList());
    }

    public static void registerStairsAndSlab(class_2248 parent, class_2248 stairs, class_2248 slab) {
        ModRegistry.registerSet(parent, Map.of(Models.STAIRS, stairs, Models.SLAB, slab));
    }

    public static void registerGlass(class_2248 parent, class_2248 pane) {
        ModRegistry.registerSet(parent, Map.of(Models.PANE, pane));
    }

    public static void registerSet(class_2248 parent, Map<Models, class_2248> set) {
        BLOCK_SETS.putIfAbsent(parent, set);
        for (Models model : set.keySet()) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(set.get((Object)model));
        }
    }

    public static void addDrop(class_2248 block, class_1935 loot) {
        BLOCK_DROPS.putIfAbsent(block, loot);
    }

    public static void clear() {
        BLOCKS.clear();
        BLOCK_TAGS.clear();
        BLOCK_DROPS.clear();
        BLOCK_STRIPPED.clear();
        BLOCK_SETS.clear();
        BLOCK_MODELS.clear();
        BLOCK_FLAMMABLE.clear();
        ITEMS.clear();
        ITEM_TAGS.clear();
        ITEM_MODELS.clear();
        ITEM_BURNABLE.clear();
    }

    public static class BlockBuilder {
        protected class_2960 id;
        protected class_2248 block;

        protected BlockBuilder(class_2960 id, class_2248 block, boolean item) {
            this.id = id;
            this.block = (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
            if (item) {
                ModRegistry.ofItem(id.method_12832(), (class_1792)new class_1747(block, (class_1792.class_1793)new FabricItemSettings())).build();
            }
        }

        public class_2248 build() {
            BLOCKS.add(this.block);
            return this.block;
        }

        public BlockBuilder drop() {
            return this.drop((class_1935)this.block);
        }

        public BlockBuilder drop(class_1935 loot) {
            BLOCK_DROPS.putIfAbsent(this.block, loot);
            return this;
        }

        public BlockBuilder tag(class_6862<class_2248> tagname) {
            BLOCK_TAGS.putIfAbsent(tagname, new ArrayList());
            BLOCK_TAGS.get(tagname).add(this.block);
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tag(class_6862<class_2248> ... tags) {
            for (class_6862<class_2248> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public BlockBuilder tagitem(class_6862<class_1792> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add(this.block.method_8389());
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tagitem(class_6862<class_1792> ... tags) {
            for (class_6862<class_1792> tagname : tags) {
                this.tagitem(tagname);
            }
            return this;
        }

        public BlockBuilder tool(String tool_material) {
            String[] needed = tool_material.split("_");
            if (needed[0].equals("stone")) {
                this.tag((class_6862<class_2248>)class_3481.field_33719);
            }
            if (needed[0].equals("iron")) {
                this.tag((class_6862<class_2248>)class_3481.field_33718);
            }
            if (needed[0].equals("diamond")) {
                this.tag((class_6862<class_2248>)class_3481.field_33717);
            }
            if (needed[1].equals("pickaxe")) {
                this.tag((class_6862<class_2248>)class_3481.field_33715);
            }
            if (needed[1].equals("axe")) {
                this.tag((class_6862<class_2248>)class_3481.field_33713);
            }
            if (needed[1].equals("shovel")) {
                this.tag((class_6862<class_2248>)class_3481.field_33716);
            }
            if (needed[1].equals("hoe")) {
                this.tag((class_6862<class_2248>)class_3481.field_33714);
            }
            if (needed[1].equals("sword")) {
                this.tag((class_6862<class_2248>)class_3481.field_44469);
            }
            return this;
        }

        public BlockBuilder end_plant() {
            return this.tag(ModTags.Blocks.END_PLANTS);
        }

        public BlockBuilder end_soil() {
            return this.tag(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }

        public BlockBuilder model() {
            return this.model(Models.CUBE);
        }

        public BlockBuilder model(Models model) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(this.block);
            return this;
        }

        public BlockBuilder model(class_4942 model) {
            ITEM_MODELS.put(this.block.method_8389(), model);
            return this;
        }

        public BlockBuilder cutout() {
            BLOCK_CUTOUT.add(this.block);
            return this;
        }

        public BlockBuilder fuel(int duration) {
            ITEM_BURNABLE.put((class_1935)this.block, duration);
            return this;
        }

        public BlockBuilder flammable(int duration, int spread) {
            BLOCK_FLAMMABLE.put(this.block, (class_3545<Integer, Integer>)new class_3545((Object)duration, (Object)spread));
            return this;
        }

        public BlockBuilder strip(class_2248 stripped) {
            BLOCK_STRIPPED.putIfAbsent(this.block, stripped);
            return this;
        }
    }

    public static class ItemBuilder {
        protected class_2960 id;
        protected class_1792 item;

        protected ItemBuilder(class_2960 id, class_1792 item) {
            this.id = id;
            this.item = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)item);
        }

        public class_1792 build() {
            ITEMS.add(this.item);
            return this.item;
        }

        public ItemBuilder tag(class_6862<class_1792> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add(this.item);
            return this;
        }

        @SafeVarargs
        public final ItemBuilder tag(class_6862<class_1792> ... tags) {
            for (class_6862<class_1792> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public ItemBuilder model() {
            return this.model(class_4943.field_22938);
        }

        public ItemBuilder model(class_4942 model) {
            ITEM_MODELS.put(this.item, model);
            return this;
        }

        public ItemBuilder fuel(int duration) {
            ITEM_BURNABLE.put((class_1935)this.item, duration);
            return this;
        }
    }

    public static enum Models {
        CUBE,
        CROSS,
        PILLAR,
        WOOD,
        STAIRS,
        SLAB,
        BUTTON,
        PRESSURE_PLATE,
        FENCE,
        FENCE_GATE,
        DOOR,
        TRAPDOOR,
        SIGN,
        WALL_SIGN,
        HANGING_SIGN,
        WALL_HANGING_SIGN,
        PANE,
        ROTATABLE;

    }

    public static class Foods {
        public static final class_4174 PREAM_BERRY = new class_4174.class_4175().method_19240().method_19237(1.0f).method_19238(4).method_19239(new class_1293(class_1294.field_5915, 1, 1, true, false), 1.0f).method_19242();
        public static final class_4174 OBLIFRUIT = new class_4174.class_4175().method_19238(6).method_19237(1.0f).method_19242();
        public static final class_4174 CHORUS_SALAD = new class_4174.class_4175().method_19240().method_19238(6).method_19237(1.5f).method_19242();
        public static final class_4174 BEHEMOTH_MEAT = new class_4174.class_4175().method_19240().method_19238(6).method_19237(0.5f).method_19239(new class_1293(class_1294.field_5910, 100, 0, true, true), 1.0f).method_19239(new class_1293(class_1294.field_5904, 100, 1, true, true), 1.0f).method_19236().method_19242();
        public static final class_4174 BEHEMOTH_STEAK = new class_4174.class_4175().method_19240().method_19238(10).method_19237(0.8f).method_19239(new class_1293(class_1294.field_5910, 300, 0, true, true), 1.0f).method_19239(new class_1293(class_1294.field_5904, 300, 1, true, true), 1.0f).method_19236().method_19242();
        public static final class_4174 POME_SLICE = new class_4174.class_4175().method_19238(4).method_19237(1.3f).method_19241().method_19242();
    }
}

