/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public class EndDataCompat {
    private static final List<Pair<class_5321<class_1959>, Supplier<Boolean>>> BIOMES = new ArrayList<Pair<class_5321<class_1959>, Supplier<Boolean>>>();

    public static void register() {
        EndDataCompat.add(ModBiomes.DREAMING_DEN, () -> ConfigEntries.doDreamingDenBiome);
        EndDataCompat.add((class_5321<class_1959>)class_1972.field_9442, () -> ConfigEntries.doDreamingDenBiome && ConfigEntries.doAcidburntAbyssesBiome && EndDataCompat.getCompatibilityMode().equals("endercon"));
        EndDataCompat.add(ModBiomes.ACIDBURNT_ABYSSES, () -> ConfigEntries.doAcidburntAbyssesBiome);
    }

    public static String getCompatibilityMode() {
        boolean auto = ConfigEntries.dataCompatMode.equals("automatic");
        if (auto) {
            if (FabricLoader.getInstance().isModLoaded("mr_endercon")) {
                return "endercon";
            }
            if (FabricLoader.getInstance().isModLoaded("nullscape")) {
                return "nullscape";
            }
            return "default";
        }
        return ConfigEntries.dataCompatMode;
    }

    public static void add(class_5321<class_1959> biome, Supplier<Boolean> condition) {
        BIOMES.add((Pair<class_5321<class_1959>, Supplier<Boolean>>)new Pair(biome, condition));
    }

    public static boolean contains(class_5321<class_1959> biome) {
        return BIOMES.stream().anyMatch(pair -> pair.getFirst() == biome);
    }

    public static List<class_5321<class_1959>> getEnabledBiomes() {
        ArrayList<class_5321<class_1959>> result = new ArrayList<class_5321<class_1959>>();
        for (Pair<class_5321<class_1959>, Supplier<Boolean>> pair : BIOMES) {
            if (!((Boolean)((Supplier)pair.getSecond()).get()).booleanValue()) continue;
            result.add((class_5321<class_1959>)((class_5321)pair.getFirst()));
        }
        return result;
    }
}

