/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature.custom;

import com.mojang.serialization.Codec;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.block.ModBlocks;
import net.minecraft.class_1299;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_2984;
import net.minecraft.class_3031;
import net.minecraft.class_39;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class ObsidianTowerStructure
extends class_3031<class_2984> {
    private static final class_1299<?> DRAGLING = (class_1299)class_7923.field_41177.method_10223(class_2960.method_43902((String)"unusualend", (String)"dragling"));
    private static final class_2960 LOOT_TABLE = Phantasm.makeID("chests/obsidian_tower");
    public static final class_3031<class_2984> INSTANCE = new ObsidianTowerStructure((Codec<class_2984>)class_2984.field_24878);

    public ObsidianTowerStructure(Codec<class_2984> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<class_2984> context) {
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        class_2984 config = (class_2984)context.method_33656();
        origin = world.method_22350(origin).method_12004().method_33943(origin.method_10264());
        int miny = world.method_31607();
        int maxy = config.method_30396().method_35008(random) + origin.method_10264();
        for (int sy = maxy = maxy + 7 - maxy % 7; sy >= miny; --sy) {
            for (int sx = -8; sx < 9; ++sx) {
                for (int sz = -8; sz < 9; ++sz) {
                    if (sx * sx + sz * sz < 64 && (sx * sx + sz * sz >= 49 || sy == maxy)) {
                        class_2248 block = class_2246.field_10540;
                        double crying = (double)(sy - 60) / ((double)maxy - 60.0);
                        if (Math.random() + 0.1 < crying * crying && crying > 0.0) {
                            block = class_2246.field_22423;
                        } else if (Math.random() < 0.2) {
                            block = Math.random() < 0.5 ? ModBlocks.POLISHED_OBSIDIAN : ModBlocks.POLISHED_OBSIDIAN_BRICKS;
                        }
                        this.method_13153((class_1945)world, origin.method_33096(sy).method_10089(sx).method_10076(sz), block.method_9564());
                        continue;
                    }
                    if (sx * sx + sz * sz < 64 && sy == miny) {
                        this.method_13153((class_1945)world, origin.method_33096(sy).method_10089(sx).method_10076(sz), class_2246.field_10027.method_9564());
                        continue;
                    }
                    if (sx * sx + sz * sz >= 49) continue;
                    this.method_13153((class_1945)world, origin.method_33096(sy).method_10089(sx).method_10076(sz), class_2246.field_10124.method_9564());
                }
            }
            if (world.method_8320(origin.method_33096(sy)).method_26215()) {
                this.method_13153((class_1945)world, origin.method_33096(sy), class_2246.field_23985.method_9564());
            }
            if (sy < maxy && sy > miny) {
                this.putStairs(world, origin.method_33096(sy));
            }
            if (sy % 7 != 0 || sy == maxy || sy == miny) continue;
            this.putPlatform((class_5425)world, origin.method_33096(sy), random.method_43048(7));
        }
        return true;
    }

    public void putStairs(class_5281 world, class_2338 center) {
        int y = center.method_10264() - world.method_31607();
        for (int sx = -7; sx < 8; ++sx) {
            for (int sz = -7; sz < 8; ++sz) {
                if (sx * sx + sz * sz < 36 || sx * sx + sz * sz >= 49 || !(sx >= 5 && y % 4 == 0 || sx <= -5 && y % 4 == 2 || sz >= 5 && y % 4 == 1) && (sz > -5 || y % 4 != 3)) continue;
                this.method_13153((class_1945)world, center.method_10089(sx).method_10076(sz), (class_2680)class_2246.field_10175.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
            }
        }
        if (Math.random() < 0.2 || center.method_10264() == 1) {
            class_2338.class_2339 door = center.method_25503();
            door = y % 4 == 0 ? door.method_10089(7) : (y % 4 == 2 ? door.method_10088(7) : (y % 4 == 1 ? door.method_10076(7) : door.method_10077(7)));
            door = door.method_10084();
            this.method_13153((class_1945)world, (class_2338)door, class_2246.field_10124.method_9564());
            this.method_13153((class_1945)world, door.method_10084(), class_2246.field_10124.method_9564());
        }
    }

    public void putPlatform(class_5425 world, class_2338 center, int roomtype) {
        if (roomtype == 0) {
            for (int sx = -5; sx < 6; ++sx) {
                for (int sz = -5; sz < 6; ++sz) {
                    if (sx * sx + sz * sz >= 16) continue;
                    this.method_13153((class_1945)world, center.method_10089(sx).method_10076(sz), class_2246.field_10286.method_9564());
                }
            }
        } else if (roomtype == 1) {
            for (int sx = -5; sx < 6; ++sx) {
                for (int sz = -5; sz < 6; ++sz) {
                    if (sx * sx + sz * sz >= 16) continue;
                    this.method_13153((class_1945)world, center.method_10089(sx).method_10076(sz), class_2246.field_10286.method_9564());
                }
            }
            this.method_13153((class_1945)world, center.method_10084(), class_2246.field_10034.method_9564());
            class_2586 sz = world.method_8321(center.method_10084());
            if (sz instanceof class_2595) {
                class_2595 chest = (class_2595)sz;
                chest.method_11285(LOOT_TABLE, world.method_8409().method_43055());
            }
        } else if (roomtype == 2) {
            this.method_13153((class_1945)world, center, class_2246.field_10260.method_9564());
            class_2586 sz = world.method_8321(center);
            if (sz instanceof class_2636) {
                class_2636 spawner = (class_2636)sz;
                class_2487 nbt = spawner.method_11390().method_8272(new class_2487());
                nbt.method_10575("MinSpawnDelay", (short)200);
                nbt.method_10575("SpawnCount", (short)1);
                nbt.method_10575("MaxNearbyEntities", (short)2);
                nbt.method_10551("SpawnData");
                spawner.method_11390().method_8280(null, center, nbt);
                spawner.method_46408(DRAGLING == class_1299.field_6093 ? class_1299.field_6059 : DRAGLING, world.method_8409());
            }
        } else if (roomtype == 3) {
            center = center.method_10076(world.method_8409().method_39332(-3, 3)).method_10089(world.method_8409().method_39332(-3, 3));
            class_2338.method_30512((class_2338)center, (int)2, (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11034).forEach(pos -> this.method_13153((class_1945)world, (class_2338)pos, class_2246.field_10540.method_9564()));
            this.method_13153((class_1945)world, center.method_10084(), class_2246.field_10034.method_9564());
            class_2586 class_25862 = world.method_8321(center.method_10084());
            if (class_25862 instanceof class_2595) {
                class_2595 chest = (class_2595)class_25862;
                chest.method_11285(class_39.field_274, world.method_8409().method_43055());
            }
        }
    }

    public static void generateRoom(class_5281 world, class_2338 center) {
        if (Math.random() < 0.5 || center.method_10264() == 1) {
            class_2338.class_2339 door = center.method_25503();
            door = Math.random() <= 0.25 ? door.method_10089(7) : (Math.random() <= 0.25 ? door.method_10088(7) : (Math.random() <= 0.25 ? door.method_10076(7) : door.method_10077(7)));
            world.method_8652((class_2338)door, class_2246.field_10124.method_9564(), 1);
            world.method_8652(door.method_10084(), class_2246.field_10124.method_9564(), 1);
        }
        if (Math.random() < 0.3) {
            world.method_8652(center, class_2246.field_10260.method_9564(), 1);
            class_2586 class_25862 = world.method_8321(center);
            if (class_25862 instanceof class_2636) {
                class_2636 spawner = (class_2636)class_25862;
                spawner.method_46408(class_1299.field_6051, world.method_8409());
            }
            world.method_8652(center.method_10084(), class_2246.field_10034.method_9564(), 1);
            class_25862 = world.method_8321(center.method_10084());
            if (class_25862 instanceof class_2595) {
                class_2595 chest = (class_2595)class_25862;
                chest.method_11285(class_39.field_842, world.method_8409().method_43055());
            }
        }
    }
}

