/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.toughasnails;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_283;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeShader;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.mixin.PostChainAccessor;
import toughasnails.api.thirst.ThirstHelper;

public class ThirstHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 5.0;
    @CreativeConfig
    public double fadeFactor = 0.05f;
    @CreativeConfig
    public IntMinMax thirstLevel = new IntMinMax(2, 8);
    @CreativeConfig
    public VisualType focus = new VisualTypeShader("focus", new class_2960("shaders/post/blobs2.json")){

        @Override
        @Environment(value=EnvType.CLIENT)
        public void changeProperties(float intensity) {
            for (class_283 pass : ((PostChainAccessor)this.postChain).getPasses()) {
                class_284 shaderuniform = pass.method_1295().method_1271("Radius");
                if (shaderuniform == null) continue;
                shaderuniform.method_1251(intensity);
            }
        }
    };
    public Visual focusVisual;

    @Override
    public void tick(@Nullable class_1657 player) {
        if (this.focusVisual == null) {
            this.focusVisual = new Visual(this.focus, this, 0);
            VisualManager.add(this.focusVisual);
        }
        double aimedSaturation = this.defaultIntensity;
        if (player != null && player.method_5805() && ThirstHelper.isThirstEnabled()) {
            int thirst = ThirstHelper.getThirst((class_1657)player).getThirst();
            if (thirst <= this.thirstLevel.max) {
                double leftFoodInSpan = thirst - this.thirstLevel.min;
                double spanLength = this.thirstLevel.spanLength();
                aimedSaturation = (1.0 - leftFoodInSpan / spanLength) * this.maxIntensity;
            }
            if ((double)this.focusVisual.getOpacityInternal() < aimedSaturation) {
                this.focusVisual.setOpacityInternal((float)Math.min((double)this.focusVisual.getOpacityInternal() + this.fadeFactor, aimedSaturation));
            } else if ((double)this.focusVisual.getOpacityInternal() > aimedSaturation) {
                this.focusVisual.setOpacityInternal((float)Math.max((double)this.focusVisual.getOpacityInternal() - this.fadeFactor, aimedSaturation));
            }
        } else {
            this.focusVisual.setOpacityInternal((float)this.defaultIntensity);
        }
    }
}

