/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.DecimalMinMax;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.creativecore.common.util.type.Color;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.FireParticlesEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.api.type.VisualTypeParticle;
import team.creative.enhancedvisuals.api.type.VisualTypeParticleColored;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.packet.DamagePacket;

public class DamageHandler
extends VisualHandler {
    public static final ArrayList<class_1792> sharpList = new ArrayList();
    public static final ArrayList<class_1792> bluntList = new ArrayList();
    public static final ArrayList<class_1792> pierceList = new ArrayList();
    public static final Color BLOOD_COLOR = new Color(0.3f, 0.01f, 0.01f, 0.7f);
    @CreativeConfig
    public VisualType damaged = new VisualTypeOverlay("damaged");
    @CreativeConfig
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public float hitEffectIntensity = 0.0f;
    @CreativeConfig
    public IntMinMax hitDuration = new IntMinMax(1, 10);
    @CreativeConfig
    public VisualType splatter = new VisualTypeParticle("splatter");
    @CreativeConfig
    public VisualType impact = new VisualTypeParticle("impact");
    @CreativeConfig
    public VisualType slash = new VisualTypeParticle("slash");
    @CreativeConfig
    public VisualType pierce = new VisualTypeParticle("pierce");
    @CreativeConfig
    public IntMinMax bloodDuration = new IntMinMax(500, 1500);
    @CreativeConfig
    public VisualType fire = new VisualTypeParticle("fire");
    @CreativeConfig
    public int fireSplashes = 1;
    @CreativeConfig
    public IntMinMax fireDuration = new IntMinMax(100, 1000);
    @CreativeConfig
    public int drownSplashes = 4;
    @CreativeConfig
    public IntMinMax drownDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType waterDrown = new VisualTypeParticleColored("blob", new Color(0, 0, 255)).setIgnoreWater();
    @CreativeConfig
    public int lightningSplashes = 10;
    @CreativeConfig
    public IntMinMax lightningDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType lightning = new VisualTypeParticleColored("shock", new Color(120, 120, 255)).setIgnoreWater();
    @CreativeConfig
    public int freezeSplashes = 4;
    @CreativeConfig
    public IntMinMax freezeDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType freeze = new VisualTypeParticleColored("ice", new Color(200, 255, 255));
    @CreativeConfig
    public int flyIntoWallSplashes = 4;
    @CreativeConfig
    public IntMinMax flyIntoWallDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType flyIntoWall = new VisualTypeParticleColored("break", new Color(255, 255, 255));
    @CreativeConfig
    public int heatSplashes = 4;
    @CreativeConfig
    public IntMinMax heatDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType heat = new VisualTypeParticleColored("heat", new Color(255, 255, 255)){

        @Override
        public boolean canRotate() {
            return false;
        }
    };
    @CreativeConfig
    public int effectSplashes = 4;
    @CreativeConfig
    public IntMinMax effectDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType parasites = new VisualTypeParticleColored("parasite", new Color(0, 126, 0)).setIgnoreWater();
    @CreativeConfig
    public VisualType wither = new VisualTypeParticleColored("wither", 0, new DecimalMinMax(1.5, 2.5), new Color(0, 0, 0)).setIgnoreWater();
    @CreativeConfig
    public IntMinMax tunnelDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType tunnel = new VisualTypeOverlay("tunnel", 0).setIgnoreWater();
    @CreativeConfig
    public DecimalCurve healthScaler = new DecimalCurve(0.0, 3.0, 12.0, 1.5);
    @CreativeConfig
    public float damageScale = 1.0f;
    @CreativeConfig
    public List<String> damageBlackList = new ArrayList<String>();

    public void clientHurt() {
        if (this.hitEffectIntensity > 0.0f) {
            VisualManager.addVisualFadeOut(this.damaged, (VisualHandler)this, (Curve)new DecimalCurve(VisualManager.RANDOM, this.hitDuration, (double)this.hitEffectIntensity * 0.2));
        }
    }

    public void playerDamaged(class_1657 player, DamagePacket packet) {
        if (packet.source.equalsIgnoreCase("attacker")) {
            if (packet.attackerClass.contains("arrow")) {
                this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            }
            if (packet.stack != null) {
                if (DamageHandler.isSharp(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isBlunt(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isPierce(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
                } else {
                    this.createVisualFromDamageAndDistance(this.splatter, packet.damage, player, this.bloodDuration);
                }
            } else if (packet.attackerClass.contains("zombie") || packet.attackerClass.contains("skeleton") || packet.attackerClass.contains("ocelot")) {
                this.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("golem") || packet.attackerClass.contains("player")) {
                this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("wolf") || packet.attackerClass.contains("spider")) {
                this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            } else {
                this.createVisualFromDamageAndDistance(this.splatter, Math.min(20.0f, packet.damage), player, this.bloodDuration);
            }
        } else if (packet.source.equalsIgnoreCase("cactus")) {
            this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
        } else if (packet.source.equalsIgnoreCase("fall") || packet.source.equalsIgnoreCase("fallingBlock")) {
            this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
        } else if (packet.source.equalsIgnoreCase("drown")) {
            VisualManager.addParticlesFadeOut(this.waterDrown, (VisualHandler)this, this.drownSplashes, this.drownDuration, true);
        } else if (packet.source.equalsIgnoreCase("hypothermia")) {
            VisualManager.addParticlesFadeOut(this.freeze, (VisualHandler)this, this.freezeSplashes, this.freezeDuration, true);
        } else if (packet.source.equalsIgnoreCase("hyperthermia")) {
            VisualManager.addParticlesFadeOut(this.heat, (VisualHandler)this, this.heatSplashes, this.heatDuration, true);
        } else if (packet.source.equalsIgnoreCase("wither")) {
            VisualManager.addParticlesFadeOut(this.wither, (VisualHandler)this, this.effectSplashes, this.effectDuration, true);
        } else if (packet.source.equalsIgnoreCase("parasites")) {
            VisualManager.addParticlesFadeOut(this.parasites, (VisualHandler)this, this.effectSplashes, this.effectDuration, true);
        } else if (packet.source.equalsIgnoreCase("lightningBolt")) {
            VisualManager.addParticlesFadeOut(this.lightning, (VisualHandler)this, this.lightningSplashes, this.lightningDuration, true);
        } else if (packet.source.equalsIgnoreCase("flyIntoWall")) {
            VisualManager.addParticlesFadeOut(this.flyIntoWall, (VisualHandler)this, this.flyIntoWallSplashes, this.flyIntoWallDuration, true);
        } else if (packet.source.equalsIgnoreCase("dehydration") || packet.source.equalsIgnoreCase("starve")) {
            VisualManager.addVisualFadeOut(this.tunnel, (VisualHandler)this, this.tunnelDuration);
        } else if (packet.fire || packet.source.equalsIgnoreCase("onFire")) {
            FireParticlesEvent event = new FireParticlesEvent(this.fireSplashes, this.fireDuration.min, this.fireDuration.max);
            CreativeCore.loader().postForge((Event)event);
            VisualManager.addParticlesFadeOut(this.fire, (VisualHandler)this, event.getNewFireSplashes(), new IntMinMax(event.getNewFireDurationMin(), event.getNewFireDurationMax()), true, new Color(0, 0, 0));
        } else if (!this.damageBlackList.contains(packet.source)) {
            this.createVisualFromDamageAndDistance(this.splatter, Math.min(20.0f, packet.damage), player, this.bloodDuration);
        }
    }

    public void createVisualFromDamageAndDistance(VisualType type, float damage, class_1657 player, IntMinMax duration) {
        if (damage <= 0.0f) {
            return;
        }
        float health = player.method_6032() - damage;
        double rate = Math.max(0.0, this.healthScaler.valueAt((double)health));
        VisualManager.addParticlesFadeOut(type, (VisualHandler)this, Math.min(5000, (int)((double)(this.damageScale * damage) * rate)), (Curve)new DecimalCurve(0.0, 1.0, (double)duration.next(VisualManager.RANDOM), 0.0), true, BLOOD_COLOR);
    }

    private static boolean isSharp(class_1799 item) {
        return sharpList.contains(item.method_7909());
    }

    private static boolean isBlunt(class_1799 item) {
        return bluntList.contains(item.method_7909());
    }

    private static boolean isPierce(class_1799 item) {
        return pierceList.contains(item.method_7909());
    }

    static {
        sharpList.add(class_1802.field_8371);
        sharpList.add(class_1802.field_8091);
        sharpList.add(class_1802.field_8528);
        sharpList.add(class_1802.field_8802);
        sharpList.add(class_1802.field_8845);
        sharpList.add(class_1802.field_8475);
        sharpList.add(class_1802.field_8406);
        sharpList.add(class_1802.field_8062);
        sharpList.add(class_1802.field_8556);
        sharpList.add(class_1802.field_8825);
        bluntList.add(class_1802.field_8403);
        bluntList.add(class_1802.field_8647);
        bluntList.add(class_1802.field_8387);
        bluntList.add(class_1802.field_8377);
        bluntList.add(class_1802.field_8335);
        bluntList.add(class_1802.field_8699);
        bluntList.add(class_1802.field_8876);
        bluntList.add(class_1802.field_8776);
        bluntList.add(class_1802.field_8250);
        bluntList.add(class_1802.field_8322);
        pierceList.add(class_1802.field_8609);
        pierceList.add(class_1802.field_8167);
        pierceList.add(class_1802.field_8431);
        pierceList.add(class_1802.field_8527);
        pierceList.add(class_1802.field_8303);
        pierceList.add(class_1802.field_8107);
    }
}

