/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import net.minecraft.class_287;
import net.raphimc.immediatelyfast.injection.interfaces.IBufferBuilder;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BufferBuilderPool {
    private static final int INITIAL_SIZE = 256;
    private static final Set<Pair<class_287, Long>> POOL = new ReferenceArraySet(256);
    private static long lastCleanup = 0L;

    private BufferBuilderPool() {
    }

    public static class_287 get() {
        RenderSystem.assertOnRenderThread();
        if (lastCleanup < System.currentTimeMillis() - 5000L) {
            lastCleanup = System.currentTimeMillis();
            BufferBuilderPool.cleanup();
        }
        for (Pair<class_287, Long> entry : POOL) {
            class_287 bufferBuilder = (class_287)entry.getKey();
            if (bufferBuilder.method_22893() || ((IBufferBuilder)bufferBuilder).immediatelyFast$isReleased()) continue;
            entry.setValue((Object)System.currentTimeMillis());
            return bufferBuilder;
        }
        class_287 bufferBuilder = new class_287(256);
        POOL.add((Pair<class_287, Long>)new MutablePair((Object)bufferBuilder, (Object)System.currentTimeMillis()));
        return bufferBuilder;
    }

    public static int getAllocatedSize() {
        BufferBuilderPool.cleanup();
        return POOL.size();
    }

    private static void cleanup() {
        POOL.removeIf(b -> ((IBufferBuilder)b.getKey()).immediatelyFast$isReleased());
        POOL.removeIf(b -> {
            if ((Long)b.getValue() < System.currentTimeMillis() - 120000L && !((class_287)b.getKey()).method_22893()) {
                ((IBufferBuilder)b.getKey()).immediatelyFast$release();
                return true;
            }
            return false;
        });
    }
}

