/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.fabric_quilt.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import elocindev.item_obliterator.fabric_quilt.ItemObliterator;
import elocindev.item_obliterator.fabric_quilt.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1863.class})
public class RecipeDisablingMixin {
    @Inject(at={@At(value="HEAD")}, method={"apply"}, cancellable=true)
    private void item_obliterator$apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        HashMap<class_2960, JsonElement> filteredMap = new HashMap<class_2960, JsonElement>();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 identifier = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                boolean shouldDisable;
                block10: {
                    JsonElement resultElement;
                    block11: {
                        String itemId;
                        block9: {
                            JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"top element");
                            resultElement = jsonObject.get("result");
                            if (resultElement == null) {
                                if (jsonObject.get("output") != null) {
                                    resultElement = jsonObject.get("output");
                                } else {
                                    filteredMap.put(identifier, jsonElement);
                                    continue;
                                }
                            }
                            shouldDisable = false;
                            if (!resultElement.isJsonObject()) break block9;
                            itemId = this.getResultItemId(resultElement.getAsJsonObject());
                            if (itemId == null || !Utils.shouldRecipeBeDisabled(itemId)) break block10;
                            shouldDisable = true;
                            break block10;
                        }
                        if (!resultElement.isJsonPrimitive() || !resultElement.getAsJsonPrimitive().isString()) break block11;
                        itemId = resultElement.getAsString();
                        if (itemId == null || !Utils.shouldRecipeBeDisabled(itemId)) break block10;
                        shouldDisable = true;
                        break block10;
                    }
                    if (resultElement.isJsonArray()) {
                        JsonArray resultArray = resultElement.getAsJsonArray();
                        for (JsonElement element : resultArray) {
                            String itemId;
                            if (element.isJsonObject()) {
                                itemId = this.getResultItemId(element.getAsJsonObject());
                                if (itemId == null || !Utils.shouldRecipeBeDisabled(itemId)) continue;
                                shouldDisable = true;
                                break;
                            }
                            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString() || (itemId = element.getAsString()) == null || !Utils.shouldRecipeBeDisabled(itemId)) continue;
                            shouldDisable = true;
                            break;
                        }
                    }
                }
                if (shouldDisable) continue;
                filteredMap.put(identifier, jsonElement);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                ItemObliterator.LOGGER.debug("Parsing error loading recipe {}", (Object)identifier, (Object)e);
                filteredMap.put(identifier, jsonElement);
            }
        }
        map.clear();
        map.putAll(filteredMap);
    }

    private String getResultItemId(JsonObject resultObject) {
        if (resultObject.has("item")) {
            return class_3518.method_15265((JsonObject)resultObject, (String)"item");
        }
        if (resultObject.has("id")) {
            return class_3518.method_15265((JsonObject)resultObject, (String)"id");
        }
        if (resultObject.has("result")) {
            return class_3518.method_15265((JsonObject)resultObject, (String)"result");
        }
        if (resultObject.has("output")) {
            return class_3518.method_15265((JsonObject)resultObject, (String)"output");
        }
        return null;
    }
}

