/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<class_3965>
implements BlockAccessor {
    private final class_2680 blockState;
    @Nullable
    private final Supplier<class_2586> blockEntity;
    private class_1799 fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, Suppliers.ofInstance((Object)builder.hit), builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    public static void handleRequest(class_2540 buf, class_3222 player, Consumer<Runnable> executor, Consumer<class_2487> responseSender) {
        BlockAccessor accessor;
        try {
            accessor = BlockAccessorImpl.fromNetwork(buf, player);
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, null, null);
            return;
        }
        executor.accept(() -> {
            class_2338 pos = accessor.getPosition();
            class_3218 world = player.method_51469();
            if (pos.method_10262((class_2382)player.method_24515()) > (double)Jade.MAX_DISTANCE_SQR || !world.method_8477(pos)) {
                return;
            }
            class_2586 tile = accessor.getBlockEntity();
            if (tile == null) {
                return;
            }
            List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.INSTANCE.getBlockNBTProviders(tile);
            if (providers.isEmpty()) {
                return;
            }
            class_2487 tag = accessor.getServerData();
            for (IServerDataProvider<BlockAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.method_10569("x", pos.method_10263());
            tag.method_10569("y", pos.method_10264());
            tag.method_10569("z", pos.method_10260());
            tag.method_10582("id", CommonProxy.getId(tile.method_11017()).toString());
            responseSender.accept(tag);
        });
    }

    public static BlockAccessor fromNetwork(class_2540 buf, class_3222 player) {
        Builder builder = new Builder();
        builder.level(player.method_37908());
        builder.player((class_1657)player);
        builder.showDetails(buf.readBoolean());
        builder.hit(buf.method_17814());
        builder.blockState(class_2248.method_9531((int)buf.method_10816()));
        builder.fakeBlock(buf.method_10819());
        if (builder.blockState.method_31709()) {
            builder.blockEntity((Supplier)Suppliers.memoize(() -> builder.level.method_8321(builder.hit.method_17777())));
        }
        return builder.build();
    }

    @Override
    public void toNetwork(class_2540 buf) {
        buf.writeBoolean(this.showDetails());
        buf.method_17813((class_3965)this.getHitResult());
        buf.method_10804(class_2248.method_9507((class_2680)this.blockState));
        buf.method_10793(this.fakeBlock);
    }

    @Override
    public class_2248 getBlock() {
        return this.getBlockState().method_26204();
    }

    @Override
    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Override
    public class_2586 getBlockEntity() {
        return this.blockEntity == null ? null : this.blockEntity.get();
    }

    @Override
    public class_2338 getPosition() {
        return ((class_3965)this.getHitResult()).method_17777();
    }

    @Override
    public class_2350 getSide() {
        return ((class_3965)this.getHitResult()).method_17780();
    }

    @Override
    public class_1799 getPickedResult() {
        return CommonProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (class_3965)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.method_7960();
    }

    @Override
    public class_1799 getFakeBlock() {
        return this.fakeBlock;
    }

    public void setFakeBlock(class_1799 fakeBlock) {
        this.fakeBlock = fakeBlock;
    }

    @Override
    public boolean verifyData(class_2487 data) {
        if (!this.verify) {
            return true;
        }
        int x = data.method_10550("x");
        int y = data.method_10550("y");
        int z = data.method_10550("z");
        class_2338 hitPos = this.getPosition();
        return x == hitPos.method_10263() && y == hitPos.method_10264() && z == hitPos.method_10260();
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private class_1937 level;
        private class_1657 player;
        private class_2487 serverData;
        private boolean connected;
        private boolean showDetails;
        private class_3965 hit;
        private class_2680 blockState = class_2246.field_10124.method_9564();
        private Supplier<class_2586> blockEntity;
        private class_1799 fakeBlock = class_1799.field_8037;
        private boolean verify;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(class_3965 hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(class_2680 blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(Supplier<class_2586> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(class_1799 stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (class_3965)accessor.getHitResult();
            this.blockEntity = accessor::getBlockEntity;
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }
}

