/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.mi;

import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.mi.MIPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public enum PipeProvider implements IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<PipeBlockEntity, class_2487>,
IClientExtensionProvider<class_2487, FluidView>
{
    INSTANCE;


    @Nullable
    public static PipeVoxelShape getHitShape(BlockAccessor accessor) {
        PipeBlockEntity pipe = (PipeBlockEntity)accessor.getBlockEntity();
        class_243 hitPos = ((class_3965)accessor.getHitResult()).method_17784();
        class_2338 blockPos = accessor.getPosition();
        for (PipeVoxelShape partShape : pipe.getPartShapes()) {
            class_243 posInBlock = hitPos.method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            for (class_238 box : partShape.shape.method_1090()) {
                class_243 dir;
                if (!box.method_1006(posInBlock.method_1019(dir = box.method_1005().method_1020(posInBlock).method_1029().method_1021(1.0E-4)))) continue;
                return partShape;
            }
        }
        return null;
    }

    public void appendServerData(class_2487 data, BlockAccessor accessor) {
        for (PipeNetworkNode node : ((PipeBlockEntity)accessor.getBlockEntity()).getNodes()) {
            FluidNetworkNode.InGameInfo info;
            class_2487 pipeData = null;
            if (node instanceof FluidNetworkNode) {
                FluidNetworkNode fluidNode = (FluidNetworkNode)node;
                info = fluidNode.collectNetworkInfo();
                pipeData = FluidView.writeDefault((JadeFluidObject)JadeFluidObject.of((class_3611)info.fluid().getFluid(), (long)Math.max(info.transfer(), info.stored())), (long)info.capacity());
            }
            if (node instanceof ElectricityNetworkNode) {
                ElectricityNetworkNode electricityNode = (ElectricityNetworkNode)node;
                info = electricityNode.collectNetworkInfo();
                pipeData = EnergyView.of((long)Math.max(info.transfer(), info.stored()), (long)info.capacity());
            }
            if (pipeData == null) continue;
            data.method_10566(node.getType().getIdentifier().toString(), pipeData);
        }
    }

    public class_2960 getUid() {
        return MIPlugin.PIPE;
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_2487>> groups) {
        class_2487 tag;
        FluidView view;
        PipeVoxelShape shape;
        BlockAccessor blockAccessor;
        if (accessor instanceof BlockAccessor && (blockAccessor = (BlockAccessor)accessor).getBlockEntity() instanceof PipeBlockEntity && (shape = PipeProvider.getHitShape(blockAccessor)) != null && (view = FluidView.readDefault((class_2487)(tag = accessor.getServerData().method_10562(shape.type.getIdentifier().toString())))) != null) {
            view.overrideText = null;
            return List.of(new ClientViewGroup(List.of(view)));
        }
        return List.of();
    }

    @Nullable
    public List<ViewGroup<class_2487>> getGroups(class_3222 player, class_3218 level, PipeBlockEntity pipe, boolean details) {
        if (pipe.getNodes().stream().anyMatch($ -> $ instanceof FluidNetworkNode)) {
            return List.of(new ViewGroup(List.of(FluidView.writeDefault((JadeFluidObject)JadeFluidObject.empty(), (long)1L))));
        }
        return List.of();
    }
}

