/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class ExportCreativeTabsCommand {
    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"creative_tabs").then(class_2170.method_9244((String)"signPos", (ArgumentType)class_2262.method_9698()).executes(ctx -> ExportCreativeTabsCommand.exportCreativeTabs((class_2168)ctx.getSource(), class_2262.method_9696((CommandContext)ctx, (String)"signPos")))));
    }

    private static int exportCreativeTabs(class_2168 source, class_2338 pos) {
        DataResult<Pair<class_2960, class_2350>> result = ExportCreativeTabsCommand.checkIsValidSign(source, pos);
        if (result.error().isPresent()) {
            source.method_9213((class_2561)class_2561.method_43470((String)((DataResult.PartialResult)result.error().get()).message()));
            return 0;
        }
        class_2350 direction = (class_2350)((Pair)result.result().orElseThrow()).getSecond();
        class_3218 level = source.method_9225();
        List<Pair<class_2338, class_1263>> containers = ExportCreativeTabsCommand.findContainerSequence(level, pos, direction);
        LinkedHashMap data = Maps.newLinkedHashMap();
        try {
            LinkedHashSet<String> items = ExportCreativeTabsCommand.collectItems(source, containers);
            if (!items.isEmpty()) {
                data.put(((class_2960)((Pair)result.result().orElseThrow()).getFirst()).toString(), items);
            }
            for (class_2350 leftOrRight : List.of(class_2470.field_11463.method_10503(direction), class_2470.field_11465.method_10503(direction))) {
                class_2338.class_2339 mutablePos = pos.method_25503().method_10098(leftOrRight);
                int failed = 0;
                while (failed < 5) {
                    mutablePos.method_10098(leftOrRight);
                    DataResult<Pair<class_2960, class_2350>> result2 = ExportCreativeTabsCommand.checkIsValidSign(source, (class_2338)mutablePos);
                    if (result2.error().isPresent()) {
                        ++failed;
                        continue;
                    }
                    Pair pair = (Pair)result2.result().orElseThrow();
                    if (direction != pair.getSecond()) {
                        ++failed;
                        continue;
                    }
                    String tabId = ((class_2960)pair.getFirst()).toString();
                    if (data.containsKey(tabId)) {
                        failed = 0;
                        continue;
                    }
                    containers = ExportCreativeTabsCommand.findContainerSequence(level, (class_2338)mutablePos, direction);
                    items = ExportCreativeTabsCommand.collectItems(source, containers);
                    if (!items.isEmpty()) {
                        data.put(tabId, items);
                    }
                    failed = 0;
                }
            }
        }
        catch (RuntimeException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return 0;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_creative_tabs.json", new String[0]), new OpenOption[0]);){
            new Gson().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Creative tabs exported"), false);
        return 1;
    }

    private static List<Pair<class_2338, class_1263>> findContainerSequence(class_3218 level, class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutablePos = pos.method_25503();
        ArrayList containers = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        while (true) {
            class_2624 blockEntity;
            mutablePos.method_10098(direction);
            class_2586 class_25862 = level.method_8321((class_2338)mutablePos);
            if (!(class_25862 instanceof class_2624)) break;
            class_2624 container = blockEntity = (class_2624)class_25862;
            class_2248 class_22482 = blockEntity.method_11010().method_26204();
            if (class_22482 instanceof class_2281) {
                class_2281 chestBlock = (class_2281)class_22482;
                if (class_2281.method_9758((class_2680)blockEntity.method_11010()) == direction.method_10153()) continue;
                container = class_2281.method_17458((class_2281)chestBlock, (class_2680)blockEntity.method_11010(), (class_1937)Objects.requireNonNull(blockEntity.method_10997()), (class_2338)mutablePos, (boolean)true);
            }
            if (!set.add(container)) continue;
            containers.add(Pair.of((Object)blockEntity.method_11016(), (Object)container));
        }
        return containers;
    }

    private static LinkedHashSet<String> collectItems(class_2168 source, List<Pair<class_2338, class_1263>> pairs) {
        class_3218 level = source.method_9225();
        LinkedHashSet items = Sets.newLinkedHashSet();
        for (Pair<class_2338, class_1263> pair : pairs) {
            level.method_8501(((class_2338)pair.getFirst()).method_10074(), class_2246.field_10490.method_9564());
        }
        for (Pair<class_2338, class_1263> pair : pairs) {
            class_1263 container = (class_1263)pair.getSecond();
            for (int i = 0; i < container.method_5439(); ++i) {
                String item;
                class_1799 stack = container.method_5438(i);
                if (stack.method_7960() || items.add(item = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString())) continue;
                for (Pair<class_2338, class_1263> pair1 : pairs) {
                    if (!((class_1263)pair1.getSecond()).method_43256($ -> class_1799.method_31577((class_1799)$, (class_1799)stack))) continue;
                    level.method_8501(((class_2338)pair1.getFirst()).method_10074(), class_2246.field_10314.method_9564());
                }
                throw new IllegalStateException("Duplicate item: %s (%s)".formatted(stack.method_7964().getString(), item));
            }
            level.method_8501(((class_2338)pair.getFirst()).method_10074(), class_2246.field_10028.method_9564());
        }
        return items;
    }

    private static DataResult<Pair<class_2960, class_2350>> checkIsValidSign(class_2168 source, class_2338 pos) {
        class_3218 level = source.method_9225();
        class_2680 blockState = level.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof class_2478)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        class_2478 block = (class_2478)class_22482;
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof class_2625)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        class_2625 blockEntity = (class_2625)class_25862;
        String signText = String.join((CharSequence)"", Arrays.stream(blockEntity.method_49853().method_49877(false)).map(class_2561::getString).toList());
        if (signText.isBlank()) {
            return DataResult.error(() -> "The sign is empty");
        }
        class_2960 tabId = class_2960.method_12829((String)signText);
        if (tabId == null) {
            return DataResult.error(() -> "The sign text is not a valid resource location");
        }
        class_2350 direction = class_2350.method_10150((double)block.method_49814(blockState)).method_10153();
        return DataResult.success((Object)Pair.of((Object)tabId, (Object)direction));
    }
}

