/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import snownee.kiwi.Kiwi;

public class ExportMappingsCommand {
    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"mappings").executes(ctx -> ExportMappingsCommand.export((class_2168)ctx.getSource())));
    }

    private static int export(class_2168 source) {
        TreeMap data = Maps.newTreeMap();
        ExportMappingsCommand.scanRegistry(class_7923.field_41175, data);
        ExportMappingsCommand.scanRegistry(class_7923.field_41178, data);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("mapping.kiwi", new String[0]), new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to export mappings", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to export mappings: " + e.getMessage())));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Done."), false);
        return 1;
    }

    private static void scanRegistry(class_2378<?> registry, Map<String, String> data) {
        for (Object o : registry) {
            String mapped;
            String className = o.getClass().getName();
            if (!className.startsWith("net.minecraft.") || data.containsKey(mapped = className.substring(14))) continue;
            String unmapped = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", className);
            unmapped = unmapped.substring(14);
            data.put(mapped, unmapped);
        }
    }
}

