/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.WandItem;

public class RepairRecipe
extends class_1852 {
    private final String group;
    private final class_1792 repairable;
    private final class_1856 material;
    private final int ratio;

    public RepairRecipe(class_2960 Id, String group, class_1792 repairable, class_1856 material, int ratio) {
        super(Id, class_7710.field_40251);
        this.group = group;
        this.repairable = repairable;
        this.material = material;
        this.ratio = ratio;
        if (repairable.method_7841() == 0) {
            throw new IllegalArgumentException(String.format("Recipe: %s, Item %s is not repairable", Id, repairable));
        }
    }

    public boolean method_8113(int width, int height) {
        return width > 1 || height > 1;
    }

    public boolean matches(class_8566 inv, class_1937 worldIn) {
        int dust = 0;
        class_1799 wand = class_1799.field_8037;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 itemstack = inv.method_5438(i);
            if (itemstack.method_7909() == this.repairable && itemstack.method_7919() != 0) {
                if (wand.method_7960()) {
                    wand = itemstack;
                    continue;
                }
                return false;
            }
            if (!itemstack.method_7960() && this.material.method_8093(itemstack)) {
                ++dust;
                continue;
            }
            if (itemstack == class_1799.field_8037) continue;
            return false;
        }
        return !wand.method_7960() && dust > 0 && wand.method_7919() - class_3532.method_15386((float)(wand.method_7936() / this.ratio)) * dust > -class_3532.method_15386((float)(wand.method_7936() / this.ratio));
    }

    public class_1799 assemble(class_8566 inv, class_5455 registryAccess) {
        int dust = 0;
        class_1799 wand = class_1799.field_8037;
        for (int i = 0; i < inv.method_5439(); ++i) {
            int count;
            class_1799 itemstack = inv.method_5438(i);
            if (itemstack.method_31574(this.repairable)) {
                wand = itemstack;
                continue;
            }
            if (itemstack.method_7960() || !this.material.method_8093(itemstack) || (count = itemstack.method_7947()) <= 0) continue;
            ++dust;
        }
        int damage = class_3532.method_15340((int)(wand.method_7919() - class_3532.method_15386((float)(wand.method_7936() / this.ratio)) * dust), (int)0, (int)((WandItem)((Object)CoreModule.WAND.get())).method_7841());
        class_1799 result = wand.method_7972();
        result.method_7939(1);
        result.method_7974(damage);
        return result;
    }

    public class_1865<?> method_8119() {
        return (class_1865)CoreModule.REPAIR.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1856 getMaterial() {
        return this.material;
    }

    public class_1792 getRepairable() {
        return this.repairable;
    }

    public int getRatio() {
        return this.ratio;
    }

    public static class Serializer
    implements class_1865<RepairRecipe> {
        public RepairRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            String s = class_3518.method_15265((JsonObject)json, (String)"repairable");
            class_1792 repairable = (class_1792)class_7923.field_41178.method_10223(new class_2960(s));
            if (repairable == class_1802.field_8162) {
                throw new JsonSyntaxException("Unknown item '" + s + "'");
            }
            class_1856 material = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"material"));
            int ratio = class_3518.method_15260((JsonObject)json, (String)"ratio");
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public RepairRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String group = buffer.method_10800(256);
            class_1792 repairable = class_1792.method_7875((int)buffer.method_10816());
            class_1856 material = class_1856.method_8086((class_2540)buffer);
            int ratio = buffer.method_10816();
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public void toNetwork(class_2540 buffer, RepairRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(class_1792.method_7880((class_1792)recipe.repairable));
            recipe.material.method_8088(buffer);
            buffer.method_10804(recipe.ratio);
        }
    }
}

