/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.compat;

import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.fabric.event.FabricShimmerReloadCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2769;
import org.joml.Vector3f;
import snownee.lightingwand.ColoredLightBlockEntity;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.LightBlock;
import snownee.lightingwand.LightEntity;
import snownee.lightingwand.WandItem;

public interface ShimmerCompat {
    public static void init() {
        FabricShimmerReloadCallback.EVENT.register(event -> {
            if (event.getReloadType() == ShimmerReloadEvent.ReloadType.COLORED_LIGHT) {
                LightManager.INSTANCE.registerItemLight((class_1792)CoreModule.WAND.get(), stack -> {
                    float range = (float)WandItem.getLightValue(stack) / 2.0f;
                    if (stack.method_7986()) {
                        range *= 1.0f - 0.9f * (float)stack.method_7919() / (float)stack.method_7936();
                    }
                    return new ColorPointLight.Template(range, ((WandItem)((Object)((Object)((Object)CoreModule.WAND.get())))).method_7800((class_1799)stack));
                });
            }
            return event;
        });
    }

    public static void addLight(LightEntity lightEntity) {
        lightEntity.shimmerLight = LightManager.INSTANCE.addLight(lightEntity.method_19538().method_46409(), 0, 1.0f);
    }

    public static void removeLight(LightEntity lightEntity) {
        ((ColorPointLight)lightEntity.shimmerLight).remove();
        lightEntity.shimmerLight = null;
    }

    public static void updateLight(LightEntity lightEntity) {
        ColorPointLight light = (ColorPointLight)lightEntity.shimmerLight;
        light.x = (float)lightEntity.method_19538().field_1352;
        light.y = (float)lightEntity.method_19538().field_1351;
        light.z = (float)lightEntity.method_19538().field_1350;
        int color = lightEntity.getColor();
        if (color == 0) {
            color = CommonConfig.defaultLightColor;
        }
        light.setColor(color);
        light.radius = (float)lightEntity.getLightValue() / 2.0f;
        light.update();
    }

    public static void addLight(ColoredLightBlockEntity lightEntity) {
        int color = lightEntity.getColor();
        if (color == 0) {
            color = CommonConfig.defaultLightColor;
        }
        if (lightEntity.shimmerLight == null) {
            class_2338 pos = lightEntity.method_11016();
            lightEntity.shimmerLight = LightManager.INSTANCE.addLight(new Vector3f((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f), color, (float)((Integer)lightEntity.method_11010().method_11654((class_2769)LightBlock.LIGHT)).intValue() / 2.0f);
        } else {
            ColorPointLight light = (ColorPointLight)lightEntity.shimmerLight;
            light.setColor(color);
            light.radius = (float)((Integer)lightEntity.method_11010().method_11654((class_2769)LightBlock.LIGHT)).intValue() / 2.0f;
            light.update();
        }
    }

    public static void removeLight(ColoredLightBlockEntity lightEntity) {
        ((ColorPointLight)lightEntity.shimmerLight).remove();
        lightEntity.shimmerLight = null;
    }
}

