/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import org.joml.Quaternionf;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.core.post.PostActionRenderer;
import snownee.lychee.client.gui.CustomLightingSettings;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CachedRenderingEntity;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class JEIREI {
    public static ILightingSettings BLOCK_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-30.0f, 45.0f).secondLightRotation(0.0f, 65.0f).build();
    public static ILightingSettings SIDE_ICON_LIGHTING = CustomLightingSettings.builder().firstLightRotation(135.0f, 35.0f).secondLightRotation(-20.0f, 50.0f).build();
    public static ILightingSettings FUSED_TNT_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-120.0f, 20.0f).secondLightRotation(200.0f, 45.0f).build();
    public static final CachedRenderingEntity<class_1541> TNT_ENTITY = CachedRenderingEntity.ofFactory(arg_0 -> ((class_1299)class_1299.field_6063).method_5883(arg_0));

    public static List<IngredientInfo> generateShapelessInputs(LycheeRecipe<?> recipe) {
        List ingredients = recipe.method_8117().stream().map(IngredientInfo::new).collect(Collectors.toCollection(ArrayList::new));
        recipe.getPostActions().forEach(action -> PostActionRenderer.of(action).loadCatalystsInfo((PostAction)action, (ILycheeRecipe<?>)recipe, ingredients));
        if (!recipe.getType().compactInputs) {
            JEIREI.addIngredientTips(recipe, ingredients);
            return ingredients;
        }
        ArrayList newIngredients = Lists.newArrayList();
        for (IngredientInfo ingredient : ingredients) {
            IngredientInfo match = null;
            if (CommonProxy.isSimpleIngredient(ingredient.ingredient)) {
                for (IngredientInfo toCompare : newIngredients) {
                    if (!Objects.equals(toCompare.tooltips, ingredient.tooltips) || !CommonProxy.isSimpleIngredient(toCompare.ingredient) || !toCompare.ingredient.method_8100().equals(ingredient.ingredient.method_8100())) continue;
                    match = toCompare;
                    break;
                }
            }
            if (match == null) {
                newIngredients.add(ingredient);
                continue;
            }
            match.count += ingredient.count;
        }
        JEIREI.addIngredientTips(recipe, newIngredients);
        return newIngredients;
    }

    public static void addIngredientTips(LycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
        for (IngredientInfo ingredient : ingredients) {
            IngredientInfo.Type type = CommonProxy.getIngredientType(ingredient.ingredient);
            if (type == IngredientInfo.Type.NORMAL) continue;
            ingredient.addTooltip((class_2561)class_2561.method_43471((String)("tip.lychee.ingredient." + type.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static class_2960 composeCategoryIdentifier(class_2960 categoryId, class_2960 group) {
        return new class_2960(categoryId.method_12836(), "%s/%s/%s".formatted(categoryId.method_12832(), group.method_12836(), group.method_12832()));
    }

    public static class_5250 makeTitle(class_2960 id) {
        int i;
        String key = id.method_42093("recipeType");
        if ("/minecraft/default".equals(key.substring(i = key.indexOf(47)))) {
            key = key.substring(0, i);
        }
        return class_2561.method_43471((String)key);
    }

    public static <T extends LycheeRecipe<?>> Pair<class_2680, Integer> getMostUsedBlock(List<T> recipes) {
        Object2IntOpenHashMap blockStateCount = new Object2IntOpenHashMap();
        HashMap blockPredicateMap = Maps.newHashMap();
        for (LycheeRecipe object : recipes) {
            BlockKeyRecipe recipe = (BlockKeyRecipe)((Object)object);
            for (class_2248 block : BlockPredicateHelper.getMatchedBlocks(recipe.getBlock())) {
                if (block.method_9564().method_26215()) continue;
                blockStateCount.mergeInt((Object)block, 1, Integer::sum);
                blockPredicateMap.putIfAbsent(block, recipe.getBlock());
            }
        }
        if (blockStateCount.isEmpty()) {
            return Pair.of(class_2246.field_10124.method_9564(), 0);
        }
        return blockStateCount.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map($ -> Pair.of(BlockPredicateHelper.anyBlockState((class_4550)blockPredicateMap.get($.getKey())), $.getIntValue())).orElseGet(() -> Pair.of(class_2246.field_10124.method_9564(), 0));
    }

    public static void registerCategories(Predicate<class_2960> categoryIdValidator, BiConsumer<class_2960, CategoryCreationContext> registrar) {
        HashMap recipes = Maps.newHashMap();
        for (LycheeRecipeType<?, ?> recipeType : RecipeTypes.ALL) {
            if (!recipeType.hasStandaloneCategory) continue;
            for (LycheeRecipe recipe : recipeType.inViewerRecipes()) {
                recipes.computeIfAbsent(recipeType.categoryId, $ -> Maps.newHashMap()).computeIfAbsent(new class_2960(recipe.group), $ -> Lists.newArrayList()).add(recipe);
            }
        }
        recipes.forEach((categoryId, map) -> {
            if (!categoryIdValidator.test((class_2960)categoryId)) {
                Lychee.LOGGER.warn("Category factory %s does not exist".formatted(categoryId));
                return;
            }
            map.forEach((group, groupRecipes) -> {
                CategoryCreationContext context = new CategoryCreationContext((class_2960)group, (List<LycheeRecipe<?>>)groupRecipes);
                registrar.accept((class_2960)categoryId, context);
            });
        });
    }

    public static List<class_2561> getRecipeTooltip(ILycheeRecipe<?> recipe) {
        ArrayList list = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)recipe.getComment())) {
            String comment = recipe.getComment();
            if (class_1074.method_4663((String)comment)) {
                comment = class_1074.method_4662((String)comment, (Object[])new Object[0]);
            }
            Splitter.on((char)'\n').splitToStream((CharSequence)comment).map(class_2561::method_43470).forEach(list::add);
        }
        class_310 mc = class_310.method_1551();
        recipe.getContextualHolder().getConditionTooltips(list, 0, (class_1937)mc.field_1687, (class_1657)mc.field_1724);
        return list;
    }

    public static void renderTnt(class_332 graphics, float x, float y) {
        class_1541 tnt = TNT_ENTITY.getEntity();
        int fuse = 80 - tnt.field_6012 % 80;
        if (fuse >= 40) {
            return;
        }
        TNT_ENTITY.earlySetLevel();
        tnt.method_6967(fuse);
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        FUSED_TNT_LIGHTING.applyLighting();
        TNT_ENTITY.render(graphics.method_51448(), x, y, 20.0f, quaternion);
    }

    public record CategoryCreationContext(class_2960 group, List<LycheeRecipe<?>> recipes) {
    }
}

