/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.rei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.architectury.event.EventResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeTags;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.rei.LEntryWidget;
import snownee.lychee.compat.rei.category.BaseREICategory;
import snownee.lychee.compat.rei.category.BlockCrushingRecipeCategory;
import snownee.lychee.compat.rei.category.BlockExplodingRecipeCategory;
import snownee.lychee.compat.rei.category.BlockInteractionRecipeCategory;
import snownee.lychee.compat.rei.category.DripstoneRecipeCategory;
import snownee.lychee.compat.rei.category.ItemBurningRecipeCategory;
import snownee.lychee.compat.rei.category.ItemExplodingRecipeCategory;
import snownee.lychee.compat.rei.category.ItemInsideRecipeCategory;
import snownee.lychee.compat.rei.category.LightningChannelingRecipeCategory;
import snownee.lychee.compat.rei.display.AnvilCraftingDisplay;
import snownee.lychee.compat.rei.display.BaseREIDisplay;
import snownee.lychee.compat.rei.display.DisplayRecipeProvider;
import snownee.lychee.compat.rei.ingredient.PostActionIngredientHelper;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.item_exploding.ItemExplodingRecipe;
import snownee.lychee.lightning_channeling.LightningChannelingRecipe;
import snownee.lychee.util.CommonProxy;

public class REICompat
implements REIClientPlugin {
    public static final class_2960 UID = new class_2960("lychee", "main");
    public static final EntryType<PostAction> POST_ACTION = EntryType.deferred((class_2960)new class_2960("lychee", "post_action"));
    public static final Map<class_2960, Map<class_2960, BaseREICategory<?, ?, ?>>> CATEGORIES = Maps.newHashMap();
    public static final List<Consumer<Map<class_2960, Function<JEIREI.CategoryCreationContext, BaseREICategory<?, ?, ?>>>>> CATEGORY_FACTORY_PROVIDERS = Lists.newArrayList();
    public static final List<Consumer<Map<class_2960, BiFunction<LycheeRecipe<?>, CategoryIdentifier<?>, BaseREIDisplay<?>>>>> DISPLAY_FACTORY_PROVIDERS = Lists.newArrayList();
    private static final Map<AllGuiTextures, ScreenElementWrapper> elMap = Maps.newIdentityHashMap();

    public static void addCategoryFactoryProvider(Consumer<Map<class_2960, Function<JEIREI.CategoryCreationContext, BaseREICategory<?, ?, ?>>>> provider) {
        CATEGORY_FACTORY_PROVIDERS.add(provider);
    }

    public static void addDisplayFactoryProvider(Consumer<Map<class_2960, BiFunction<LycheeRecipe<?>, CategoryIdentifier<?>, BaseREIDisplay<?>>>> provider) {
        DISPLAY_FACTORY_PROVIDERS.add(provider);
    }

    public void registerCategories(CategoryRegistry registration) {
        HashMap factories = Maps.newHashMap();
        factories.put(RecipeTypes.ITEM_BURNING.categoryId, $ -> new ItemBurningRecipeCategory(RecipeTypes.ITEM_BURNING));
        factories.put(RecipeTypes.ITEM_INSIDE.categoryId, $ -> new ItemInsideRecipeCategory(RecipeTypes.ITEM_INSIDE, (ScreenElement)AllGuiTextures.JEI_DOWN_ARROW));
        factories.put(RecipeTypes.BLOCK_INTERACTING.categoryId, $ -> {
            AllGuiTextures mainIcon = $.recipes().stream().map(LycheeRecipe::getType).anyMatch(Predicate.isEqual(RecipeTypes.BLOCK_INTERACTING)) ? AllGuiTextures.RIGHT_CLICK : AllGuiTextures.LEFT_CLICK;
            return new BlockInteractionRecipeCategory(List.of(RecipeTypes.BLOCK_INTERACTING, RecipeTypes.BLOCK_CLICKING), (ScreenElement)mainIcon);
        });
        factories.put(RecipeTypes.BLOCK_CRUSHING.categoryId, $ -> new BlockCrushingRecipeCategory(RecipeTypes.BLOCK_CRUSHING));
        factories.put(RecipeTypes.LIGHTNING_CHANNELING.categoryId, $ -> new LightningChannelingRecipeCategory((LycheeRecipeType<ItemShapelessContext, LightningChannelingRecipe>)RecipeTypes.LIGHTNING_CHANNELING));
        factories.put(RecipeTypes.ITEM_EXPLODING.categoryId, $ -> new ItemExplodingRecipeCategory((LycheeRecipeType<ItemShapelessContext, ItemExplodingRecipe>)RecipeTypes.ITEM_EXPLODING));
        factories.put(RecipeTypes.BLOCK_EXPLODING.categoryId, $ -> new BlockExplodingRecipeCategory(RecipeTypes.BLOCK_EXPLODING, (ScreenElement)GuiGameElement.of((class_1935)class_1802.field_8626)));
        factories.put(RecipeTypes.DRIPSTONE_DRIPPING.categoryId, $ -> new DripstoneRecipeCategory(RecipeTypes.DRIPSTONE_DRIPPING));
        CATEGORY_FACTORY_PROVIDERS.forEach($ -> $.accept(factories));
        JEIREI.registerCategories(factories::containsKey, (categoryId, context) -> {
            BaseREICategory category = (BaseREICategory)((Function)factories.get(categoryId)).apply(context);
            category.categoryIdentifier = CategoryIdentifier.of((class_2960)JEIREI.composeCategoryIdentifier(categoryId, context.group()));
            category.initialRecipes = context.recipes();
            category.icon = category.createIcon(context.recipes());
            registration.add((DisplayCategory)category);
            CATEGORIES.computeIfAbsent((class_2960)categoryId, $ -> Maps.newHashMap()).put(context.group(), category);
        });
        REICompat.forEachCategories(RecipeTypes.BLOCK_CRUSHING, $ -> $.initialRecipes.stream().map(BlockKeyRecipe::getBlock).distinct().map(BlockPredicateHelper::getMatchedBlocks).flatMap(Collection::stream).distinct().map(class_1935::method_8389).filter(Predicate.not(class_1802.field_8162::equals)).map(class_1792::method_7854).forEach($$ -> registration.addWorkstations($.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1799)$$)})));
        REICompat.forEachCategories(RecipeTypes.LIGHTNING_CHANNELING, $ -> registration.addWorkstations($.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_27051)}));
        for (class_1792 item : CommonProxy.tagElements(class_7923.field_41178, LycheeTags.ITEM_EXPLODING_CATALYSTS)) {
            REICompat.forEachCategories(RecipeTypes.ITEM_EXPLODING, $ -> registration.addWorkstations($.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1799)item.method_7854())}));
        }
        for (class_1792 item : CommonProxy.tagElements(class_7923.field_41178, LycheeTags.BLOCK_EXPLODING_CATALYSTS)) {
            REICompat.forEachCategories(RecipeTypes.BLOCK_EXPLODING, $ -> registration.addWorkstations($.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1799)item.method_7854())}));
        }
        REICompat.forEachCategories(RecipeTypes.DRIPSTONE_DRIPPING, $ -> registration.addWorkstations($.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_28042)}));
        CategoryExtensionProvider extensionProvider = (display, category, lastView) -> {
            if (display instanceof DisplayRecipeProvider) {
                DisplayRecipeProvider d = (DisplayRecipeProvider)display;
                final ILycheeRecipe<?> recipe = d.recipe();
                return new DisplayCategoryView<Display>(){

                    public DisplayRenderer getDisplayRenderer(Display display) {
                        return lastView.getDisplayRenderer(display);
                    }

                    public List<Widget> setupDisplay(Display display, Rectangle bounds) {
                        List widgets = lastView.setupDisplay(display, bounds);
                        class_768 rect = null;
                        for (Widget widget : widgets) {
                            if (!(widget instanceof Arrow)) continue;
                            Arrow arrow = (Arrow)widget;
                            rect = new class_768(arrow.getBounds().getCenterX() - bounds.getX() - 4, Math.max(arrow.getY() - bounds.getY() - 9, 4), 8, 8);
                            break;
                        }
                        if (rect != null) {
                            BaseREICategory.drawInfoBadge(widgets, recipe, bounds.getLocation(), rect);
                        }
                        return widgets;
                    }
                };
            }
            return lastView;
        };
        registration.get(CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting")).registerExtension(extensionProvider);
        registration.get(CategoryIdentifier.of((String)"minecraft", (String)"plugins/anvil")).registerExtension(extensionProvider);
    }

    public static <C extends LycheeContext, T extends LycheeRecipe<C>, D extends BaseREIDisplay<T>> void forEachCategories(LycheeRecipeType<C, T> recipeType, Consumer<BaseREICategory<C, T, D>> consumer) {
        CATEGORIES.getOrDefault(recipeType.categoryId, Map.of()).values().stream().map($ -> $).forEach(consumer);
    }

    public void registerDisplays(DisplayRegistry registration) {
        HashMap factories = Maps.newHashMap();
        CATEGORIES.keySet().forEach($ -> REICompat.registerDisplayFactory(factories, $, BaseREIDisplay::new));
        DISPLAY_FACTORY_PROVIDERS.forEach($ -> $.accept(factories));
        CATEGORIES.values().forEach($ -> $.values().forEach($$ -> {
            BaseREICategory category = $$;
            category.initialRecipes.forEach($$$ -> {
                class_2960 categoryId = $$$.getType().categoryId;
                registration.add((Display)((BiFunction)factories.get(categoryId)).apply($$$, $$.categoryIdentifier));
            });
        }));
        try {
            CommonProxy.recipes(RecipeTypes.ANVIL_CRAFTING).stream().filter($ -> !$.getResultItem().method_7960() && !$.method_8118() && $.showInRecipeViewer()).map(AnvilCraftingDisplay::new).forEach(arg_0 -> ((DisplayRegistry)registration).add(arg_0));
        }
        catch (Throwable e) {
            Lychee.LOGGER.error("", e);
        }
        registration.registerVisibilityPredicate((category, display) -> {
            DisplayRecipeProvider d;
            if (display instanceof DisplayRecipeProvider && !(d = (DisplayRecipeProvider)display).recipe().showInRecipeViewer()) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    public static <C extends LycheeContext, T extends LycheeRecipe<C>, D extends BaseREIDisplay<T>> void registerDisplayFactory(Map<class_2960, BiFunction<LycheeRecipe<?>, CategoryIdentifier<?>, BaseREIDisplay<?>>> factories, class_2960 id, BiFunction<T, CategoryIdentifier<D>, ? extends D> factory) {
        factories.put(id, factory);
    }

    public void registerEntryTypes(EntryTypeRegistry registration) {
        registration.register(POST_ACTION, (EntryDefinition)new PostActionIngredientHelper());
    }

    public static ScreenElementWrapper el(AllGuiTextures element) {
        return elMap.computeIfAbsent(element, ScreenElementWrapper::new);
    }

    public static LEntryWidget slot(Point startPoint, int x, int y, SlotType slotType) {
        LEntryWidget widget = new LEntryWidget(new Point(startPoint.x + x + 1, startPoint.y + y + 1));
        widget.background(slotType.element);
        return widget;
    }

    public static Rectangle offsetRect(Point startPoint, class_768 rect) {
        return new Rectangle(startPoint.x + rect.method_3321(), startPoint.y + rect.method_3322(), rect.method_3319(), rect.method_3320());
    }

    public static class ScreenElementWrapper
    extends WidgetWithBounds {
        public final Rectangle bounds = new Rectangle(16, 16);
        private final ScreenElement element;

        private ScreenElementWrapper(AllGuiTextures element) {
            this.element = element;
            this.bounds.width = element.width;
            this.bounds.height = element.height;
        }

        public ScreenElementWrapper(RenderElement element) {
            this.element = element;
            this.bounds.width = element.getWidth();
            this.bounds.height = element.getHeight();
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.element.render(graphics, this.bounds.x, this.bounds.y);
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }

    public static enum SlotType {
        NORMAL(AllGuiTextures.JEI_SLOT),
        CHANCE(AllGuiTextures.JEI_CHANCE_SLOT),
        CATALYST(AllGuiTextures.JEI_CATALYST_SLOT);

        final ScreenElement element;

        private SlotType(AllGuiTextures element) {
            this.element = REICompat.el((AllGuiTextures)element).element;
        }
    }
}

