/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.rei;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

public class ReactiveWidget
extends WidgetWithBounds {
    private boolean focused = false;
    private boolean focusable = true;
    private final Rectangle bounds;
    private Point point;
    @Nullable
    private @Nullable Function<ReactiveWidget, @Nullable class_2561[]> tooltip;
    @Nullable
    private BiConsumer<ReactiveWidget, Integer> onClick;

    public ReactiveWidget(Rectangle bounds) {
        this.bounds = bounds;
        this.point = new Point(bounds.getCenterX(), bounds.getMaxY());
    }

    public final Point getPoint() {
        return this.point;
    }

    public final void setPoint(Point point) {
        this.point = Objects.requireNonNull(point);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_2561[] tooltip;
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltipLines()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create((class_2561[])tooltip).queue();
            } else if (this.focused) {
                Tooltip.create((Point)this.point, (class_2561[])tooltip).queue();
            }
        }
    }

    @Nullable
    public final class_2561[] getTooltipLines() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    public final void setTooltipFunction(@Nullable @Nullable Function<ReactiveWidget, @Nullable class_2561[]> tooltip) {
        this.tooltip = tooltip;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            this.onClick.accept(this, button);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this, 0);
        }
        return true;
    }

    public final boolean isClickable() {
        return this.getOnClick() != null;
    }

    @Nullable
    public final BiConsumer<ReactiveWidget, Integer> getOnClick() {
        return this.onClick;
    }

    public final void setOnClick(@Nullable BiConsumer<ReactiveWidget, Integer> onClick) {
        this.onClick = onClick;
    }

    public final boolean isFocusable() {
        return this.focusable;
    }

    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }
}

