/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.ActionRuntime;
import snownee.lychee.core.EmptyContainer;
import snownee.lychee.core.Job;
import snownee.lychee.core.input.ItemHolderCollection;
import snownee.lychee.core.post.Delay;
import snownee.lychee.core.post.PostAction;

public class LycheeContext
extends EmptyContainer {
    private final class_5819 random;
    private final Map<class_169<?>, Object> params;
    private final class_1937 level;
    private class_47 cachedLootContext;
    public ActionRuntime runtime;
    public ItemHolderCollection itemHolders = ItemHolderCollection.EMPTY;
    @Nullable
    public JsonObject json;

    protected LycheeContext(class_5819 pRandom, class_1937 level, Map<class_169<?>, Object> pParams) {
        this.random = pRandom;
        this.level = level;
        this.params = pParams;
    }

    public boolean hasParam(class_169<?> pParameter) {
        if (pParameter == class_181.field_1228) {
            this.lazyGetBlockEntity();
        }
        return this.params.containsKey(pParameter);
    }

    public <T> T getParam(class_169<T> pParam) {
        Object t;
        if (pParam == class_181.field_1228) {
            this.lazyGetBlockEntity();
        }
        if ((t = this.params.get(pParam)) == null) {
            throw new NoSuchElementException(pParam.method_746().toString());
        }
        return (T)t;
    }

    public Map<class_169<?>, Object> getParams() {
        return this.params;
    }

    @Nullable
    public <T> T getParamOrNull(class_169<T> pParameter) {
        if (pParameter == class_181.field_1228) {
            this.lazyGetBlockEntity();
        }
        return (T)this.params.get(pParameter);
    }

    public class_5819 getRandom() {
        return this.random;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public class_3218 getServerLevel() {
        return (class_3218)this.level;
    }

    public class_47 toLootContext() {
        if (this.cachedLootContext == null) {
            this.lazyGetBlockEntity();
            class_8567.class_8568 paramsBuilder = new class_8567.class_8568((class_3218)this.level);
            this.params.forEach((p, o) -> paramsBuilder.method_51874(p, o));
            class_47.class_48 builder = new class_47.class_48(paramsBuilder.method_51875(LycheeLootContextParamSets.ALL));
            this.cachedLootContext = builder.method_309(null);
        }
        return this.cachedLootContext;
    }

    public void lazyGetBlockEntity() {
        class_2586 blockEntity;
        if (this.params.containsKey(class_181.field_1228)) {
            return;
        }
        class_2338 pos = this.getParamOrNull(LycheeLootContextParams.BLOCK_POS);
        if (pos == null) {
            pos = class_2338.method_49638((class_2374)((class_2374)this.getParam(class_181.field_24424)));
            this.setParam(LycheeLootContextParams.BLOCK_POS, pos);
        }
        if ((blockEntity = this.level.method_8321(pos)) != null) {
            this.setParam(class_181.field_1228, blockEntity);
        }
    }

    public void setParam(class_169<?> param, Object value) {
        this.params.put(param, value);
    }

    public void removeParam(class_169<?> param) {
        this.params.remove(param);
    }

    @Override
    public int method_5439() {
        return this.itemHolders.size();
    }

    @Override
    public class_1799 method_5438(int index) {
        return this.itemHolders.get(index).get();
    }

    @Override
    public void method_5447(int index, class_1799 stack) {
        this.itemHolders.replace(index, stack);
    }

    public void enqueueActions(Stream<PostAction> actions, int times, boolean startNew) {
        if (this.runtime == null || startNew) {
            this.runtime = new ActionRuntime();
        }
        this.runtime.enqueue(actions, times);
    }

    public JsonObject save() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("doDefault", Boolean.valueOf(this.runtime.doDefault));
        JsonArray jobs = new JsonArray(this.runtime.jobs.size());
        JsonArray jobRepeats = new JsonArray(this.runtime.jobs.size());
        for (Job job : this.runtime.jobs) {
            jobs.add((JsonElement)job.action.toJson());
            jobRepeats.add((Number)job.times);
        }
        jsonObject.add("jobs", (JsonElement)jobs);
        jsonObject.add("jobRepeats", (JsonElement)jobRepeats);
        if (this.json != null) {
            jsonObject.add("json", (JsonElement)this.json);
        }
        return jsonObject;
    }

    public static LycheeContext load(JsonObject jsonObject, Delay.LycheeMarker marker) {
        Builder builder = new Builder(marker.getEntity().method_37908());
        builder.withParameter(class_181.field_24424, marker.getEntity().method_19538());
        Object ctx = builder.create(LycheeLootContextParamSets.ALL);
        ((LycheeContext)ctx).runtime = new ActionRuntime();
        ((LycheeContext)ctx).runtime.doDefault = jsonObject.get("doDefault").getAsBoolean();
        JsonArray jobs = jsonObject.getAsJsonArray("jobs");
        JsonArray jobRepeats = jsonObject.getAsJsonArray("jobRepeats");
        ArrayList jobList = Lists.newArrayList();
        for (int i = 0; i < jobs.size(); ++i) {
            Job job = new Job(PostAction.parse(jobs.get(i).getAsJsonObject()), jobRepeats.get(i).getAsInt());
            jobList.add(job);
        }
        ((LycheeContext)ctx).runtime.jobs.addAll(0, jobList);
        ((LycheeContext)ctx).runtime.marker = marker;
        if (jsonObject.has("json")) {
            ((LycheeContext)ctx).json = jsonObject.getAsJsonObject("json");
        }
        return ctx;
    }

    public static class Builder<C extends LycheeContext> {
        protected Map<class_169<?>, Object> params = Maps.newIdentityHashMap();
        protected class_1937 level;
        protected class_5819 random;

        public Builder(class_1937 level) {
            this.level = level;
        }

        public Builder<C> withRandom(class_5819 pRandom) {
            this.random = pRandom;
            return this;
        }

        public Builder<C> withOptionalRandomSeed(long pSeed) {
            if (pSeed != 0L) {
                this.random = class_5819.method_43049((long)pSeed);
            }
            return this;
        }

        public Builder<C> withOptionalRandomSeed(long pSeed, class_5819 pRandom) {
            this.random = pSeed == 0L ? pRandom : class_5819.method_43049((long)pSeed);
            return this;
        }

        public <T> Builder<C> withParameter(class_169<T> pParameter, T pValue) {
            this.params.put(pParameter, pValue);
            return this;
        }

        public <T> Builder<C> withOptionalParameter(class_169<T> pParameter, @Nullable T pValue) {
            if (pValue == null) {
                this.params.remove(pParameter);
            } else {
                this.params.put(pParameter, pValue);
            }
            return this;
        }

        public <T> T getParameter(class_169<T> pParameter) {
            Object t = this.params.get(pParameter);
            if (t == null) {
                throw new IllegalArgumentException("No parameter " + String.valueOf(pParameter));
            }
            return (T)t;
        }

        @Nullable
        public <T> T getOptionalParameter(class_169<T> pParameter) {
            return (T)this.params.get(pParameter);
        }

        protected void beforeCreate(class_176 pParameterSet) {
            Sets.SetView set1 = Sets.difference((Set)pParameterSet.method_778(), this.params.keySet());
            if (!set1.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(set1));
            }
            if (this.random == null) {
                this.random = class_5819.method_43047();
            }
        }

        public C create(class_176 pParameterSet) {
            this.beforeCreate(pParameterSet);
            return (C)new LycheeContext(this.random, this.level, this.params);
        }

        public void setParams(Map<class_169<?>, Object> params) {
            this.params = params;
        }
    }
}

