/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3518;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class ContextualHolder {
    private static final class_2561 SECRET_TITLE = class_2561.method_43471((String)"contextual.lychee.secret").method_27692(class_124.field_1080);
    private List<ContextualCondition> conditions = List.of();
    @Nullable
    private BitSet secretFlags;
    @Nullable
    private List<class_2561> overrideDesc;

    public List<ContextualCondition> getConditions() {
        return this.conditions;
    }

    public int showingConditionsCount() {
        return this.conditions.stream().mapToInt(ContextualCondition::showingCount).sum();
    }

    public void withCondition(ContextualCondition condition) {
        Objects.requireNonNull(condition);
        if (this.conditions.isEmpty()) {
            this.conditions = Lists.newArrayList();
        }
        this.conditions.add(condition);
    }

    public void parseConditions(JsonElement element) {
        if (element != null) {
            if (element.isJsonObject()) {
                this.parse(element.getAsJsonObject());
            } else {
                JsonArray array = element.getAsJsonArray();
                for (int x = 0; x < array.size(); ++x) {
                    this.parse(array.get(x).getAsJsonObject());
                }
            }
        }
    }

    private void parse(JsonObject o) {
        this.withCondition(ContextualCondition.parse(o));
        if (class_3518.method_15258((JsonObject)o, (String)"secret", (boolean)false)) {
            if (this.secretFlags == null) {
                this.secretFlags = new BitSet(this.conditions.size());
            }
            this.secretFlags.set(this.conditions.size() - 1);
        }
        if (o.has("description")) {
            if (this.overrideDesc == null) {
                this.overrideDesc = Lists.newArrayList();
            }
            while (this.overrideDesc.size() + 1 < this.conditions.size()) {
                this.overrideDesc.add(null);
            }
            this.overrideDesc.add((class_2561)class_2561.method_43471((String)class_3518.method_15265((JsonObject)o, (String)"description")));
        }
    }

    public void conditionsFromNetwork(class_2540 pBuffer) {
        int i;
        int size = pBuffer.method_10816();
        for (i = 0; i < size; ++i) {
            ContextualConditionType<?> type = CommonProxy.readRegistryId(LycheeRegistries.CONTEXTUAL, pBuffer);
            this.withCondition((ContextualCondition)type.fromNetwork(pBuffer));
        }
        if (pBuffer.readBoolean()) {
            this.secretFlags = pBuffer.method_33558();
        }
        if (pBuffer.readBoolean()) {
            this.overrideDesc = Lists.newArrayListWithCapacity((int)size);
            for (i = 0; i < size; ++i) {
                String key = pBuffer.method_19772();
                if (key.isEmpty()) {
                    this.overrideDesc.add(null);
                    continue;
                }
                this.overrideDesc.add((class_2561)class_2561.method_43471((String)key));
            }
        }
    }

    public void conditionsToNetwork(class_2540 pBuffer) {
        pBuffer.method_10804(this.conditions.size());
        for (ContextualCondition condition : this.conditions) {
            ContextualConditionType<? extends ContextualCondition> type = condition.getType();
            CommonProxy.writeRegistryId(LycheeRegistries.CONTEXTUAL, type, pBuffer);
            type.toNetwork(condition, pBuffer);
        }
        pBuffer.writeBoolean(this.secretFlags != null);
        if (this.secretFlags != null) {
            pBuffer.method_33557(this.secretFlags);
        }
        pBuffer.writeBoolean(this.overrideDesc != null);
        if (this.overrideDesc != null) {
            for (class_2561 component : this.overrideDesc) {
                class_7417 class_74172;
                if (component == null || !((class_74172 = component.method_10851()) instanceof class_2588)) {
                    pBuffer.method_10814("");
                    continue;
                }
                class_2588 translatable = (class_2588)class_74172;
                pBuffer.method_10814(translatable.method_11022());
            }
        }
    }

    public JsonElement rawConditionsToJson() {
        if (this.conditions.size() == 1) {
            return this.conditions.get(0).toJson();
        }
        JsonArray array = new JsonArray();
        this.conditions.forEach($ -> array.add((JsonElement)$.toJson()));
        return array;
    }

    public int checkConditions(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        try {
            boolean first = true;
            for (ContextualCondition condition : this.conditions) {
                if (first && condition.getType() == ContextualConditionTypes.CHANCE && this instanceof ChanceRecipe) continue;
                first = false;
                if ((times = condition.test(recipe, ctx, times)) != 0) continue;
                break;
            }
            return times;
        }
        catch (Throwable e) {
            Lychee.LOGGER.error("Failed to check conditions for recipe {}", (Object)recipe.lychee$getId(), (Object)e);
            return 0;
        }
    }

    public boolean isSecretCondition(int index) {
        if (this.secretFlags == null) {
            return false;
        }
        return this.secretFlags.get(index);
    }

    public void getConditionTooltips(List<class_2561> list, int indent, @Nullable class_1937 level, @Nullable class_1657 player) {
        if (level == null) {
            return;
        }
        int i = 0;
        for (ContextualCondition condition : this.getConditions()) {
            if (this.isSecretCondition(i)) {
                result = condition.testInTooltips(level, player);
                ContextualCondition.desc(list, result, indent, SECRET_TITLE.method_27661());
            } else if (this.isOverridenDesc(i)) {
                result = condition.testInTooltips(level, player);
                ContextualCondition.desc(list, result, indent, this.overrideDesc.get(i).method_27661());
            } else {
                condition.appendTooltips(list, level, player, indent, false);
            }
            ++i;
        }
    }

    private boolean isOverridenDesc(int i) {
        if (this.overrideDesc != null && this.overrideDesc.size() > i) {
            return this.overrideDesc.get(i) != null;
        }
        return false;
    }
}

