/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_181;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DirectionCheck
implements ContextualCondition {
    public static final Map<String, DirectionCheck> LOOKUP = Maps.newHashMap();
    private final String name;
    private final Predicate<LycheeContext> predicate;

    public static void create(String name, Predicate<LycheeContext> predicate) {
        LOOKUP.put(name, new DirectionCheck(name, predicate));
    }

    private DirectionCheck(String name, Predicate<LycheeContext> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.DIRECTION;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx) ? times : 0;
    }

    @Override
    public class_5250 getDescription(boolean inverted) {
        class_5250 value = class_2561.method_43471((String)("direction.lychee." + this.name)).method_27692(class_124.field_1068);
        return class_2561.method_43469((String)this.makeDescriptionId(inverted), (Object[])new Object[]{value});
    }

    static {
        class_2350[] class_2350Array = class_2350.values();
        int n = class_2350Array.length;
        for (int i = 0; i < n; ++i) {
            class_2350 direction;
            class_2350 direction2 = direction = class_2350Array[i];
            DirectionCheck.create(direction2.method_10151().toLowerCase(Locale.ENGLISH), ctx -> ctx.getParam(LycheeLootContextParams.DIRECTION) == direction2);
        }
        DirectionCheck.create("sides", ctx -> ctx.getParam(LycheeLootContextParams.DIRECTION).method_10164() == 0);
        DirectionCheck.create("forward", ctx -> {
            class_2680 state;
            class_2350 facing;
            class_2350 direction = ctx.getParam(LycheeLootContextParams.DIRECTION);
            return direction == (facing = (class_2350)(state = (class_2680)ctx.getParam(class_181.field_1224)).method_28500((class_2769)class_2741.field_12525).or(() -> state.method_28500((class_2769)class_2741.field_12481)).or(() -> state.method_28500((class_2769)class_2741.field_28062)).orElseThrow());
        });
        DirectionCheck.create("axis", ctx -> {
            class_2350 direction = ctx.getParam(LycheeLootContextParams.DIRECTION);
            class_2680 state = (class_2680)ctx.getParam(class_181.field_1224);
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_28500((class_2769)class_2741.field_12496).or(() -> state.method_28500((class_2769)class_2741.field_12529)).orElseThrow();
            return axis.method_10176(direction);
        });
    }

    public static class Type
    extends ContextualConditionType<DirectionCheck> {
        @Override
        public DirectionCheck fromJson(JsonObject o) {
            return LOOKUP.get(o.get("direction").getAsString());
        }

        @Override
        public void toJson(DirectionCheck condition, JsonObject o) {
            o.addProperty("direction", condition.name);
        }

        @Override
        public DirectionCheck fromNetwork(class_2540 buf) {
            return LOOKUP.get(buf.method_19772());
        }

        @Override
        public void toNetwork(DirectionCheck condition, class_2540 buf) {
            buf.method_10814(condition.name);
        }
    }
}

