/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public record IsWeather(String id, Predicate<class_1937> predicate) implements ContextualCondition
{
    public static final Map<String, IsWeather> REGISTRY = Maps.newConcurrentMap();
    public static IsWeather CLEAR = IsWeather.create("clear", level -> !level.method_8419() && !level.method_8546());
    public static IsWeather RAIN = IsWeather.create("rain", level -> level.method_8419());
    public static IsWeather THUNDER = IsWeather.create("thunder", level -> level.method_8546());

    public static IsWeather create(String id, Predicate<class_1937> predicate) {
        IsWeather isWeather = new IsWeather(id, predicate);
        REGISTRY.put(id, isWeather);
        return isWeather;
    }

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.WEATHER;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx.getLevel()) ? times : 0;
    }

    @Override
    public class_1269 testInTooltips(class_1937 level, @Nullable class_1657 player) {
        return this.predicate.test(level) ? class_1269.field_5812 : class_1269.field_5814;
    }

    @Override
    public class_5250 getDescription(boolean inverted) {
        String key = this.makeDescriptionId(inverted);
        class_5250 weather = class_2561.method_43471((String)("weather.lychee." + this.id));
        return class_2561.method_43469((String)key, (Object[])new Object[]{weather.method_27692(class_124.field_1068)});
    }

    public static class Type
    extends ContextualConditionType<IsWeather> {
        @Override
        public IsWeather fromJson(JsonObject o) {
            return REGISTRY.get(o.get("weather").getAsString());
        }

        @Override
        public void toJson(IsWeather condition, JsonObject o) {
            o.addProperty("weather", condition.id());
        }

        @Override
        public IsWeather fromNetwork(class_2540 buf) {
            return REGISTRY.get(buf.method_19772());
        }

        @Override
        public void toNetwork(IsWeather condition, class_2540 buf) {
            buf.method_10814(condition.id());
        }
    }
}

