/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonObject;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.def.TimeCheckHelper;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.IntRangeAccess;
import snownee.lychee.mixin.TimeCheckAccess;
import snownee.lychee.util.CommonProxy;

public record Time(class_2096.class_2100 value, @Nullable Long period) implements ContextualCondition
{
    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.TIME;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.test((class_1936)ctx.getLevel()) ? times : 0;
    }

    @Override
    public class_1269 testInTooltips(class_1937 level, @Nullable class_1657 player) {
        return CommonProxy.interactionResult(this.test((class_1936)level));
    }

    public boolean test(class_1936 level) {
        long i = level.method_30271();
        if (this.period != null) {
            i %= this.period.longValue();
        }
        return this.value.method_9054((int)i);
    }

    @Override
    public class_5250 getDescription(boolean inverted) {
        return class_2561.method_43471((String)this.makeDescriptionId(inverted));
    }

    public static class Type
    extends ContextualConditionType<Time> {
        @Override
        public Time fromJson(JsonObject o) {
            TimeCheckAccess access = (TimeCheckAccess)TimeCheckHelper.fromJson(o);
            return new Time(IntBoundsHelper.fromIntRange((IntRangeAccess)access.getValue()), access.getPeriod());
        }

        @Override
        public void toJson(Time condition, JsonObject o) {
            if (condition.period() != null) {
                o.addProperty("period", (Number)condition.period());
            }
            o.add("value", condition.value().method_9036());
        }

        @Override
        public Time fromNetwork(class_2540 buf) {
            class_2096.class_2100 range = IntBoundsHelper.fromNetwork(buf);
            Long period = buf.readLong();
            if (period <= 0L) {
                period = null;
            }
            return new Time(range, period);
        }

        @Override
        public void toNetwork(Time condition, class_2540 buf) {
            IntBoundsHelper.toNetwork(condition.value(), buf);
            buf.writeLong(condition.period() == null ? Long.MIN_VALUE : condition.period());
        }
    }
}

