/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.input;

import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_243;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.input.ItemHolder;
import snownee.lychee.util.CommonProxy;

public abstract class ItemHolderCollection {
    public static final ItemHolderCollection EMPTY = InWorld.of(new class_1542[0]);
    protected final ItemHolder[] holders;
    public final List<class_1799> tempList = Lists.newArrayList();
    public final BitSet ignoreConsumptionFlags;

    public ItemHolderCollection(ItemHolder ... holders) {
        this.holders = holders;
        this.ignoreConsumptionFlags = new BitSet(holders.length);
    }

    public ItemHolder get(int index) {
        return this.holders[index];
    }

    public ItemHolder split(int index, int amount) {
        ItemHolder holder;
        this.holders[index] = holder = this.get(index).split(amount, this.tempList::add);
        return holder;
    }

    public ItemHolder replace(int index, class_1799 item) {
        ItemHolder holder;
        this.holders[index] = holder = this.get(index).replace(item, this.tempList::add);
        return holder;
    }

    protected int consumeInputs(int times) {
        int total = 0;
        for (int i = 0; i < this.holders.length; ++i) {
            ItemHolder holder = this.holders[i];
            if (this.ignoreConsumptionFlags.get(i) || holder.get().method_7960()) continue;
            this.holders[i].get().method_7934(times);
            total += times;
        }
        return total;
    }

    public abstract int postApply(boolean var1, int var2);

    public int size() {
        return this.holders.length;
    }

    public static class InWorld
    extends ItemHolderCollection {
        private class_1542 itemEntity;

        public InWorld(ItemHolder.InWorld ... holders) {
            super(holders);
            if (holders.length > 0) {
                this.itemEntity = holders[0].getEntity();
            }
        }

        public static ItemHolderCollection of(class_1542 ... entities) {
            return new InWorld((ItemHolder.InWorld[])Stream.of(entities).map(ItemHolder.InWorld::new).toArray(ItemHolder.InWorld[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            for (class_1799 stack : this.tempList) {
                if (stack.method_7960()) continue;
                class_243 pos = this.itemEntity.method_19538();
                class_1542 newEntity = new class_1542(this.itemEntity.method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, stack);
                this.itemEntity.method_37908().method_8649((class_1297)newEntity);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }

    public static class Inventory
    extends ItemHolderCollection {
        private LycheeContext ctx;

        public Inventory(LycheeContext ctx, ItemHolder.Simple ... holders) {
            super(holders);
            this.ctx = ctx;
        }

        public static ItemHolderCollection of(LycheeContext ctx, class_1799 ... items) {
            return new Inventory(ctx, (ItemHolder.Simple[])Stream.of(items).map(ItemHolder.Simple::new).toArray(ItemHolder.Simple[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            class_1297 entity = (class_1297)this.ctx.getParamOrNull(class_181.field_1226);
            class_1657 player = null;
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
            }
            class_243 pos = (class_243)this.ctx.getParamOrNull(class_181.field_24424);
            for (class_1799 stack : this.tempList) {
                if (player != null) {
                    if (player.method_7270(stack)) continue;
                    player.method_7328(stack, false);
                    continue;
                }
                if (pos == null) continue;
                CommonProxy.dropItemStack(this.ctx.getLevel(), pos.field_1352, pos.field_1351, pos.field_1350, stack, null);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }
}

