/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4550;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.PostActionTypes;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.NbtPredicateAccess;
import snownee.lychee.mixin.StatePropertiesPredicateAccess;
import snownee.lychee.util.CommonProxy;

public class PlaceBlock
extends PostAction {
    public final class_4550 block;
    public final class_2338 offset;

    public PlaceBlock(class_4550 block, class_2338 offset) {
        this.block = block;
        this.offset = offset;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.PLACE;
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        class_2586 blockentity;
        class_2338 pos = ctx.getParamOrNull(LycheeLootContextParams.BLOCK_POS);
        if (pos == null) {
            pos = class_2338.method_49638((class_2374)((class_2374)ctx.getParam(class_181.field_24424)));
        }
        pos = pos.method_10081((class_2382)this.offset);
        class_3218 level = ctx.getServerLevel();
        class_2680 oldState = level.method_8320(pos);
        class_2680 state = this.getNewState(oldState);
        if (state == null) {
            return;
        }
        if (state.method_26215()) {
            PlaceBlock.destroyBlock((class_1937)level, pos, false);
            return;
        }
        if (recipe instanceof BlockCrushingRecipe && !oldState.method_26215()) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)oldState));
        }
        BlockPredicateAccess access = (BlockPredicateAccess)this.block;
        if (this.getType() == PostActionTypes.PLACE) {
            Set properties = ((StatePropertiesPredicateAccess)access.getProperties()).getProperties().stream().map($ -> $.method_22533()).collect(Collectors.toSet());
            for (Map.Entry entry : oldState.method_11656().entrySet()) {
                class_2769 property = (class_2769)entry.getKey();
                if (properties.contains(property.method_11899()) || !state.method_28498(property)) continue;
                state = (class_2680)state.method_11657(property, (Comparable)entry.getValue());
            }
            if (state.method_28498((class_2769)class_2741.field_12508) && oldState.method_26227().method_33659((class_3611)class_3612.field_15910)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
        }
        if (!level.method_8501(pos, state)) {
            return;
        }
        class_2105 nbtPredicate = access.getNbt();
        if (this.getType() == PostActionTypes.PLACE && nbtPredicate != class_2105.field_9716 && (blockentity = level.method_8321(pos)) != null) {
            class_2487 compoundtag1 = blockentity.method_38244();
            class_2487 compoundtag2 = compoundtag1.method_10553();
            compoundtag1.method_10543(((NbtPredicateAccess)nbtPredicate).getTag());
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.method_11014(compoundtag1);
                blockentity.method_5431();
            }
        }
        level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
    }

    @Nullable
    protected class_2680 getNewState(class_2680 oldState) {
        return BlockPredicateHelper.anyBlockState(this.block);
    }

    private static boolean destroyBlock(class_1937 level, class_2338 pos, boolean drop) {
        boolean flag;
        class_2680 legacy;
        class_2680 blockstate = level.method_8320(pos);
        if (blockstate.method_26215()) {
            return false;
        }
        class_3610 fluidstate = level.method_8316(pos);
        if (!(blockstate.method_26204() instanceof class_4770)) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockstate));
        }
        if (drop) {
            class_2586 blockentity = blockstate.method_31709() ? level.method_8321(pos) : null;
            class_2248.method_9511((class_2680)blockstate, (class_1937)level, (class_2338)pos, (class_2586)blockentity, null, (class_1799)class_1799.field_8037);
        }
        if ((legacy = fluidstate.method_15759()) == blockstate) {
            legacy = class_2246.field_10124.method_9564();
        }
        if (flag = level.method_30092(pos, legacy, 3, 512)) {
            level.method_33596(null, class_5712.field_28165, pos);
        }
        return flag;
    }

    @Override
    public class_2561 getDisplayName() {
        class_2680 state = BlockPredicateHelper.anyBlockState(this.block);
        String key = CommonProxy.makeDescriptionId("postAction", PostActionTypes.PLACE.getRegistryName());
        if (state.method_26215()) {
            return class_2561.method_43471((String)(key + ".consume"));
        }
        return class_2561.method_43469((String)key, (Object[])new Object[]{state.method_26204().method_9518()});
    }

    @Override
    public List<class_1799> getItemOutputs() {
        return BlockPredicateHelper.getMatchedItemStacks(this.block);
    }

    @Override
    public List<class_4550> getBlockOutputs() {
        return List.of(this.block);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    public static class Type
    extends PostActionType<PlaceBlock> {
        @Override
        public PlaceBlock fromJson(JsonObject o) {
            return new PlaceBlock(BlockPredicateHelper.fromJson(o.get("block")), CommonProxy.parseOffset(o));
        }

        @Override
        public void toJson(PlaceBlock action, JsonObject o) {
            class_2338 offset = action.offset;
            if (offset.method_10263() != 0) {
                o.addProperty("offsetX", (Number)offset.method_10263());
            }
            if (offset.method_10264() != 0) {
                o.addProperty("offsetY", (Number)offset.method_10264());
            }
            if (offset.method_10260() != 0) {
                o.addProperty("offsetZ", (Number)offset.method_10263());
            }
            o.add("block", BlockPredicateHelper.toJson(action.block));
        }

        @Override
        public PlaceBlock fromNetwork(class_2540 buf) {
            return new PlaceBlock(BlockPredicateHelper.fromNetwork(buf), buf.method_10811());
        }

        @Override
        public void toNetwork(PlaceBlock action, class_2540 buf) {
            BlockPredicateHelper.toNetwork(action.block, buf);
            buf.method_10807(action.offset);
        }
    }
}

