/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DamageItem
extends PostAction {
    public final int damage;
    public final Reference target;

    public DamageItem(int damage, Reference target) {
        this.damage = damage;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        class_1297 thisEntity = (class_1297)ctx.getParam(class_181.field_1226);
        class_1309 entity = thisEntity instanceof class_1309 ? (class_1309)thisEntity : null;
        for (Integer index : indexes) {
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
            class_1799 itemStack = ctx.itemHolders.split(index, 1).get();
            if (entity == null) {
                if (!itemStack.method_7970(this.damage, ctx.getRandom(), null)) continue;
                itemStack.method_7934(1);
                itemStack.method_7974(0);
                continue;
            }
            if (entity.method_6047() == itemStack) {
                itemStack.method_7956(this.damage, entity, $ -> $.method_20235(class_1304.field_6173));
                continue;
            }
            if (entity.method_6079() == itemStack) {
                itemStack.method_7956(this.damage, entity, $ -> $.method_20235(class_1304.field_6171));
                continue;
            }
            itemStack.method_7956(this.damage, entity, $ -> {});
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((recipe.getItemIndexes(this.target).size() > 0 ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    extends PostActionType<DamageItem> {
        @Override
        public DamageItem fromJson(JsonObject o) {
            return new DamageItem(class_3518.method_15282((JsonObject)o, (String)"damage", (int)1), Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(DamageItem action, JsonObject o) {
            if (action.damage != 1) {
                o.addProperty("damage", (Number)1);
            }
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public DamageItem fromNetwork(class_2540 buf) {
            return new DamageItem(buf.method_10816(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(DamageItem action, class_2540 buf) {
            buf.method_10804(action.damage);
            Reference.toNetwork(action.target, buf);
        }
    }
}

