/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.util.json.JsonPatch;
import snownee.lychee.util.json.JsonPointer;

public interface ILycheeRecipe<C extends LycheeContext> {
    public static final JsonPointer ITEM_IN = new JsonPointer("/item_in");
    public static final JsonPointer ITEM_OUT = new JsonPointer("/item_out");
    public static final JsonPointer RESULT = new JsonPointer("/result");
    public static final JsonPointer POST = new JsonPointer("/post");
    public static final Map<class_2960, NBTPatchContext> patchContexts = Maps.newHashMap();

    default public class_2960 lychee$getId() {
        return ((class_1860)this).method_8114();
    }

    default public IntList getItemIndexes(Reference reference) {
        JsonPointer pointer = null;
        if (reference == Reference.DEFAULT) {
            pointer = this.defaultItemPointer();
        } else if (reference.isPointer()) {
            pointer = reference.getPointer();
        }
        if (pointer != null) {
            return this.getItemIndexes(pointer);
        }
        return IntList.of();
    }

    public IntList getItemIndexes(JsonPointer var1);

    default public JsonPointer defaultItemPointer() {
        return ITEM_IN;
    }

    public Stream<PostAction> getPostActions();

    default public Stream<PostAction> getAllActions() {
        return this.getPostActions();
    }

    public Map<JsonPointer, List<PostAction>> getActionGroups();

    public static Stream<PostAction> filterHidden(Stream<PostAction> stream) {
        return stream.filter(Predicate.not(PostAction::isHidden));
    }

    default public int showingActionsCount() {
        return (int)ILycheeRecipe.filterHidden(this.getPostActions()).count();
    }

    public ContextualHolder getContextualHolder();

    @Nullable
    public String getComment();

    public boolean showInRecipeViewer();

    default public void applyPostActions(LycheeContext ctx, int times) {
        if (!ctx.getLevel().field_9236) {
            ctx.enqueueActions(this.getPostActions(), times, true);
            ctx.runtime.run(this, ctx);
        }
    }

    default public List<class_4550> getBlockInputs() {
        ILycheeRecipe iLycheeRecipe = this;
        if (iLycheeRecipe instanceof BlockKeyRecipe) {
            BlockKeyRecipe blockKeyRecipe = (BlockKeyRecipe)((Object)iLycheeRecipe);
            return List.of(blockKeyRecipe.getBlock());
        }
        return List.of();
    }

    default public List<class_4550> getBlockOutputs() {
        return ILycheeRecipe.filterHidden(this.getAllActions()).map(PostAction::getBlockOutputs).flatMap(Collection::stream).toList();
    }

    default public boolean isActionPath(JsonPointer pointer) {
        return !pointer.isRoot() && "post".equals(pointer.getString(0));
    }

    public static void processActions(ILycheeRecipe<?> recipe, JsonObject recipeObject) {
        MutableObject patchContext = new MutableObject();
        HashSet usedPointers = Sets.newHashSet();
        recipe.getAllActions().forEach(action -> action.getUsedPointers(recipe, usedPointers::add));
        if (!usedPointers.isEmpty()) {
            IntArraySet usedIndexes = new IntArraySet();
            Object2IntArrayMap splits = new Object2IntArrayMap();
            usedPointers.forEach(arg_0 -> ILycheeRecipe.lambda$processActions$1(recipe, recipeObject, (IntSet)usedIndexes, (Object2IntMap)splits, arg_0));
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<JsonPointer, List<PostAction>> entry : recipe.getActionGroups().entrySet()) {
                List<PostAction> actions;
                JsonPointer pointer = entry.getKey();
                JsonElement element = ILycheeRecipe.processActionGroup(recipe, pointer, actions = entry.getValue(), recipeObject);
                if (element == null) continue;
                JsonPatch.add((JsonElement)jsonObject, pointer, element);
            }
            patchContext.setValue((Object)new NBTPatchContext(jsonObject, (IntCollection)usedIndexes, (Object2IntMap<JsonPointer>)splits));
            patchContexts.put(recipe.lychee$getId(), (NBTPatchContext)patchContext.getValue());
        } else {
            patchContexts.remove(recipe.lychee$getId());
        }
        recipe.getAllActions().forEach(action -> {
            try {
                action.validate(recipe, (NBTPatchContext)patchContext.getValue());
            }
            catch (Exception e) {
                Lychee.LOGGER.error("Error while validating action " + String.valueOf(action), (Throwable)e);
            }
        });
    }

    public static JsonElement processActionGroup(ILycheeRecipe<?> recipe, JsonPointer pointer, List<PostAction> actions, JsonObject recipeObject) {
        if (actions.isEmpty()) {
            return null;
        }
        JsonElement element = pointer.find((JsonElement)recipeObject);
        if (element == null) {
            return null;
        }
        if (element.isJsonObject()) {
            element = actions.get(0).provideJsonInfo(recipe, pointer, recipeObject);
            if (element.isJsonNull()) {
                return null;
            }
            return element;
        }
        JsonArray array = new JsonArray();
        int size = element.getAsJsonArray().size();
        for (int i = 0; i < size; ++i) {
            array.add(actions.get(i).provideJsonInfo(recipe, pointer.append(Integer.toString(i)), recipeObject));
        }
        return array;
    }

    private static /* synthetic */ void lambda$processActions$1(ILycheeRecipe recipe, JsonObject recipeObject, IntSet usedIndexes, Object2IntMap splits, JsonPointer pointer) {
        if (recipe.isActionPath(pointer)) {
            return;
        }
        ArrayList tokens = Lists.newArrayList(pointer.tokens);
        while (!tokens.isEmpty()) {
            IntList indexes;
            JsonPointer current = new JsonPointer(tokens);
            if (current.find((JsonElement)recipeObject) != null && !(indexes = recipe.getItemIndexes(current)).isEmpty()) {
                usedIndexes.addAll((IntCollection)indexes);
                splits.put((Object)pointer, current.toString().length());
                break;
            }
            tokens.remove(tokens.size() - 1);
        }
    }

    public record NBTPatchContext(JsonObject template, IntCollection usedIndexes, Object2IntMap<JsonPointer> splits) {
        public JsonPointer convertPath(JsonPointer path, BiFunction<String, String, String> composer) {
            int index = this.splits.getOrDefault((Object)path, -1);
            if (index == -1) {
                return path;
            }
            String s = path.toString();
            String first = s.substring(0, index);
            String last = s.substring(index);
            return new JsonPointer(composer.apply(first, last));
        }

        public int countTargets(ILycheeRecipe<?> recipe, Reference reference) {
            JsonPointer pointer = null;
            if (reference == Reference.DEFAULT) {
                pointer = recipe.defaultItemPointer();
            } else if (reference.isPointer()) {
                pointer = reference.getPointer();
            }
            if (pointer == null) {
                return 0;
            }
            return this.countTargets(recipe, pointer);
        }

        public int countTargets(ILycheeRecipe<?> recipe, JsonPointer pointer) {
            if (recipe.isActionPath(pointer)) {
                return 1;
            }
            int index = this.splits.getOrDefault((Object)pointer, -1);
            if (index == -1) {
                return 0;
            }
            return recipe.getItemIndexes(new JsonPointer(pointer.toString().substring(0, index))).size();
        }
    }
}

