/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.util.RecipeMatcher;

public abstract class ItemShapelessRecipe<T extends ItemShapelessRecipe<T>>
extends LycheeRecipe<ItemShapelessContext>
implements Comparable<T> {
    public static final int MAX_INGREDIENTS = 27;
    protected class_2371<class_1856> ingredients = class_2371.method_10211();

    public ItemShapelessRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(ItemShapelessContext ctx, class_1937 pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<class_1542> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.method_8093($.method_6983()))).limit(27L).toList();
        List<class_1799> items = itemEntities.stream().map(class_1542::method_6983).toList();
        Optional<RecipeMatcher<class_1799>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(class_1799::method_7947).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @Override
    public int compareTo(T that) {
        int i = Integer.compare(this.getMaxRepeats().method_9041() ? 1 : 0, ((LycheeRecipe)that).getMaxRepeats().method_9041() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.method_8118() ? 1 : 0, that.method_8118() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), ((ItemShapelessRecipe)that).ingredients.size());
        if (i != 0) {
            return i;
        }
        return this.method_8114().method_12833(((LycheeRecipe)that).method_8114());
    }

    public static class Serializer<T extends ItemShapelessRecipe<T>>
    extends LycheeRecipe.Serializer<T> {
        public Serializer(Function<class_2960, T> factory) {
            super(factory);
        }

        @Override
        public void fromJson(T pRecipe, JsonObject pSerializedRecipe) {
            if (pSerializedRecipe.has("item_in")) {
                JsonElement itemIn = pSerializedRecipe.get("item_in");
                if (itemIn.isJsonArray()) {
                    itemIn.getAsJsonArray().forEach($ -> pRecipe.ingredients.add((Object)class_1856.method_52177((JsonElement)$)));
                } else {
                    ((ItemShapelessRecipe)pRecipe).ingredients.add((Object)class_1856.method_52177((JsonElement)itemIn));
                }
            }
            if (!((ItemShapelessRecipe)pRecipe).ghost) {
                Preconditions.checkArgument((((ItemShapelessRecipe)pRecipe).ingredients.size() <= 27 ? 1 : 0) != 0, (String)"Ingredients cannot be more than %s", (int)27);
            }
        }

        @Override
        public void fromNetwork(T pRecipe, class_2540 pBuffer) {
            pBuffer.method_34068(i -> pRecipe.ingredients, class_1856::method_8086);
        }

        @Override
        public void toNetwork0(class_2540 pBuffer, T pRecipe) {
            pBuffer.method_34062(((ItemShapelessRecipe)pRecipe).ingredients, (b, i) -> i.method_8088(b));
        }
    }
}

