/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4550;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.Chance;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.input.ItemHolderCollection;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class BlockKeyRecipeType<C extends LycheeContext, T extends LycheeRecipe<C>>
extends LycheeRecipeType<C, T> {
    protected final Map<class_2248, List<T>> recipesByBlock = Maps.newHashMap();
    protected final List<T> anyBlockRecipes = Lists.newLinkedList();
    public boolean extractChance;

    public BlockKeyRecipeType(String name, Class<T> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
    }

    @Override
    public void buildCache() {
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        super.buildCache();
        HashMultimap multimap = HashMultimap.create();
        for (LycheeRecipe lycheeRecipe : this.recipes) {
            Object condition;
            if (!lycheeRecipe.getConditions().isEmpty() && (condition = lycheeRecipe.getConditions().get(0)) instanceof Chance) {
                Chance chance = (Chance)condition;
                ((ChanceRecipe)((Object)lycheeRecipe)).setChance(chance.chance());
            }
            if (((BlockKeyRecipe)((Object)lycheeRecipe)).getBlock() == class_4550.field_20692) {
                this.anyBlockRecipes.add(lycheeRecipe);
                continue;
            }
            condition = BlockPredicateHelper.getMatchedBlocks(((BlockKeyRecipe)((Object)lycheeRecipe)).getBlock()).iterator();
            while (condition.hasNext()) {
                class_2248 block = (class_2248)condition.next();
                multimap.put((Object)block, (Object)lycheeRecipe);
            }
        }
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            list.sort(null);
            this.recipesByBlock.put((class_2248)entry.getKey(), list);
        }
    }

    public List<class_1799> blockKeysToItems() {
        return this.recipesByBlock.keySet().stream().map(class_2248::method_8389).filter($ -> $ != class_1802.field_8162).sorted(Comparator.comparingInt(class_1792::method_7880)).map(class_1792::method_7854).toList();
    }

    public Optional<T> process(class_1657 player, class_1268 hand, class_2338 pos, class_243 origin, LycheeContext.Builder<C> ctxBuilder) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        class_1937 level = player.method_37908();
        class_2680 blockstate = level.method_8320(pos);
        Collection recipes = this.recipesByBlock.getOrDefault(blockstate.method_26204(), List.of());
        if (recipes.isEmpty() && this.anyBlockRecipes.isEmpty()) {
            return Optional.empty();
        }
        ctxBuilder.withParameter(class_181.field_24424, CommonProxy.clampPos(origin, pos));
        ctxBuilder.withParameter(class_181.field_1226, player);
        ctxBuilder.withParameter(class_181.field_1224, blockstate);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        C ctx = ctxBuilder.create(this.contextParamSet);
        class_1799 stack = player.method_5998(hand);
        class_1799 otherStack = player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
        ((LycheeContext)ctx).itemHolders = ItemHolderCollection.Inventory.of(ctx, new class_1799[]{stack, otherStack});
        Iterable<T> iterable = this.mergeAnyBlockRecipes(recipes);
        for (LycheeRecipe recipe : iterable) {
            if (!this.tryMatch(recipe, level, ctx).isPresent()) continue;
            if (!level.field_9236 && recipe.tickOrApply(ctx)) {
                int times = Math.min(((LycheeContext)ctx).method_5438(0).method_7947(), ((LycheeContext)ctx).method_5438(1).method_7947());
                times = recipe.getRandomRepeats(Math.max(1, times), ctx);
                if (recipe.method_8117().size() == 1) {
                    ((LycheeContext)ctx).itemHolders.ignoreConsumptionFlags.set(1);
                }
                recipe.applyPostActions((LycheeContext)ctx, times);
                ((LycheeContext)ctx).itemHolders.postApply(((LycheeContext)ctx).runtime.doDefault, times);
                player.method_6122(hand, ((LycheeContext)ctx).method_5438(0));
                player.method_6122(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808, ((LycheeContext)ctx).method_5438(1));
            }
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public boolean has(class_2248 block) {
        return !this.anyBlockRecipes.isEmpty() || this.recipesByBlock.containsKey(block);
    }

    public boolean has(class_2680 state) {
        return this.has(state.method_26204());
    }

    @Nullable
    public Pair<C, T> process(class_1937 level, class_2680 state, Supplier<C> ctxSupplier) {
        Collection recipes = this.recipesByBlock.getOrDefault(state.method_26204(), List.of());
        Iterable<T> iterable = this.mergeAnyBlockRecipes(recipes);
        LycheeContext ctx = null;
        for (LycheeRecipe recipe : iterable) {
            ChanceRecipe $;
            if (this.extractChance && ($ = (ChanceRecipe)((Object)recipe)).getChance() != 1.0f && $.getChance() <= level.field_9229.method_43057()) continue;
            if (ctx == null) {
                ctx = (LycheeContext)ctxSupplier.get();
            }
            if (!this.tryMatch(recipe, level, ctx).isPresent()) continue;
            recipe.applyPostActions(ctx, 1);
            return Pair.of(ctx, recipe);
        }
        return null;
    }

    public Iterable<T> mergeAnyBlockRecipes(Collection<T> recipes) {
        if (this.anyBlockRecipes.isEmpty()) {
            return recipes;
        }
        if (recipes.isEmpty()) {
            return this.anyBlockRecipes;
        }
        return Iterables.concat(recipes, this.anyBlockRecipes);
    }
}

