/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe.type;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1542;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;

public class ItemShapelessRecipeType<C extends ItemShapelessContext, T extends LycheeRecipe<C>>
extends LycheeRecipeType<C, T> {
    private LycheeRecipeType.ValidItemCache validItems = new LycheeRecipeType.ValidItemCache();

    public ItemShapelessRecipeType(String name, Class<T> clazz, @Nullable class_176 contextParamSet) {
        super(name, clazz, contextParamSet);
        this.compactInputs = true;
    }

    @Override
    public void buildCache() {
        super.buildCache();
        this.validItems.buildCache(this.recipes);
    }

    public void process(class_1937 level, Stream<class_1542> itemEntities, Consumer<ItemShapelessContext.Builder<C>> ctxBuilderConsumer) {
        if (this.isEmpty()) {
            return;
        }
        List list = itemEntities.filter($ -> this.validItems.contains($.method_6983())).collect(Collectors.toCollection(LinkedList::new));
        ItemShapelessContext.Builder ctxBuilder = new ItemShapelessContext.Builder(level, list);
        ctxBuilderConsumer.accept(ctxBuilder);
        ItemShapelessRecipeType.process(this, this.recipes, ctxBuilder.create(this.contextParamSet), null);
    }

    public static <C extends ItemShapelessContext, T extends LycheeRecipe<C>> void process(LycheeRecipeType<C, T> recipeType, Iterable<T> recipes, C ctx, Predicate<T> test) {
        boolean matched;
        boolean matchedAny = false;
        int loop = 0;
        HashSet excluded = Sets.newHashSet();
        block2: do {
            matched = false;
            for (LycheeRecipe recipe : recipes) {
                if (recipe.method_8117().isEmpty() && loop > 0 || excluded.contains(recipe)) continue;
                try {
                    Optional<T> match = recipeType.tryMatch(recipe, ctx.getLevel(), ctx);
                    if (!match.isPresent()) continue;
                    if (test != null && !test.test(recipe)) {
                        excluded.add(recipe);
                        continue;
                    }
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    if (ctx.getMatch() != null && ctx.getMatch().inputUsed.length > 0) {
                        int[] inputUsed = ctx.getMatch().inputUsed;
                        times = recipe.getRandomRepeats(Integer.MAX_VALUE, ctx);
                        for (int i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            class_1799 stack = ctx.filteredItems.get(i).method_6983();
                            times = Math.min(times, stack.method_7947() / inputUsed[i]);
                        }
                    }
                    ((LycheeRecipe)match.get()).applyPostActions(ctx, times);
                    if (ctx.getMatch() != null) {
                        ctx.totalItems -= ctx.itemHolders.postApply(ctx.runtime.doDefault, times);
                    }
                    if (recipe.getMaxRepeats().method_9041()) {
                        ctx.filteredItems = null;
                        ctx.setMatch(null);
                        ctx.itemEntities.removeIf($ -> $.method_6983().method_7960());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            ctx.itemEntities.forEach($ -> $.method_6979($.method_6983()));
        }
    }
}

