/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.dripstone_dripping;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4550;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.Job;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.Location;
import snownee.lychee.core.contextual.Not;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.Break;
import snownee.lychee.core.post.Delay;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.dripstone_dripping.DripstoneContext;
import snownee.lychee.mixin.PointedDripstoneBlockAccess;
import snownee.lychee.util.Pair;

public class DripstoneRecipe
extends LycheeRecipe<DripstoneContext>
implements BlockKeyRecipe<DripstoneRecipe>,
ChanceRecipe {
    private float chance = 1.0f;
    protected class_4550 sourceBlock;
    protected class_4550 targetBlock;

    public DripstoneRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(DripstoneContext ctx, class_1937 level) {
        if (!BlockPredicateHelper.fastMatch(this.targetBlock, ctx)) {
            return false;
        }
        return BlockPredicateHelper.fastMatch(this.sourceBlock, ctx.source, () -> level.method_8321(ctx.getParam(LycheeLootContextParams.BLOCK_POS)));
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.DRIPSTONE_DRIPPING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.DRIPSTONE_DRIPPING;
    }

    @Override
    public int compareTo(DripstoneRecipe that) {
        int i = Integer.compare(this.method_8118() ? 1 : 0, that.method_8118() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.targetBlock == class_4550.field_20692 ? 1 : 0, that.targetBlock == class_4550.field_20692 ? 1 : 0);
        if (i != 0) {
            return i;
        }
        return this.method_8114().method_12833(that.method_8114());
    }

    @Override
    public class_4550 getBlock() {
        return this.targetBlock;
    }

    public class_4550 getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public List<class_4550> getBlockInputs() {
        return List.of(this.sourceBlock, this.targetBlock);
    }

    @Override
    public void applyPostActions(LycheeContext ctx, int times) {
        if (!ctx.getLevel().field_9236) {
            ctx.enqueueActions(this.getPostActions(), times, true);
        }
    }

    public static boolean safeTick(class_2680 state, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (!PointedDripstoneBlockAccess.callIsStalactiteStartPos(state, (class_4538)serverLevel, blockPos)) {
            return false;
        }
        float f = randomSource.method_43057();
        if (f > 0.17578125f && f > 0.05859375f) {
            return false;
        }
        return DripstoneRecipe.on(state, serverLevel, blockPos);
    }

    public static boolean on(class_2680 blockState, class_3218 level, class_2338 blockPos) {
        if (RecipeTypes.DRIPSTONE_DRIPPING.isEmpty()) {
            return false;
        }
        class_2338 tipPos = PointedDripstoneBlockAccess.callFindTip(blockState, (class_1936)level, blockPos, 11, false);
        if (tipPos == null) {
            return false;
        }
        class_2338 targetPos = DripstoneRecipe.findTargetBelowStalactiteTip((class_1937)level, tipPos);
        if (targetPos == null) {
            return false;
        }
        class_2680 sourceBlock = DripstoneRecipe.getBlockAboveStalactite((class_1937)level, blockPos, blockState);
        if (sourceBlock == null) {
            return false;
        }
        class_2680 targetBlock = level.method_8320(targetPos);
        Pair result = RecipeTypes.DRIPSTONE_DRIPPING.process((class_1937)level, targetBlock, () -> {
            DripstoneContext.Builder builder = new DripstoneContext.Builder((class_1937)level, sourceBlock);
            builder.withParameter(class_181.field_1224, targetBlock);
            class_243 origin = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.99, (double)targetPos.method_10260() + 0.5);
            builder.withParameter(class_181.field_24424, origin);
            builder.withParameter(LycheeLootContextParams.BLOCK_POS, targetPos);
            return builder.create(LycheeLootContextParamSets.BLOCK_ONLY);
        });
        if (result == null) {
            return false;
        }
        DripstoneContext ctx = result.getFirst();
        DripstoneRecipe recipe = (DripstoneRecipe)result.getSecond();
        level.method_20290(1504, tipPos, 0);
        int i = tipPos.method_10264() - targetPos.method_10264();
        int j = 50 + i;
        Break breakAction = new Break();
        class_2090.class_2091 builder = new class_2090.class_2091().method_27989(recipe.targetBlock);
        class_205 check = (class_205)class_205.method_884((class_2090.class_2091)builder).build();
        breakAction.withCondition(new Not(new Location(check)));
        ctx.runtime.jobs.push(new Job(breakAction, 1));
        ctx.runtime.jobs.push(new Job(new Delay((float)j / 20.0f), 1));
        ctx.runtime.run(recipe, ctx);
        return true;
    }

    @Nullable
    private static class_2338 findTargetBelowStalactiteTip(class_1937 level, class_2338 blockPos2) {
        Predicate<class_2680> predicate = blockState -> !blockState.method_26215() && RecipeTypes.DRIPSTONE_DRIPPING.has((class_2680)blockState);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccess.callCanDripThrough((class_1922)level, blockPos, blockState);
        return PointedDripstoneBlockAccess.callFindBlockVertical((class_1936)level, blockPos2, class_2350.field_11033.method_10171(), biPredicate, predicate, 11).orElse(null);
    }

    public static class_2680 getBlockAboveStalactite(class_1937 level, class_2338 blockPos2, class_2680 blockState) {
        return PointedDripstoneBlockAccess.callFindRootBlock(level, blockPos2, blockState, 11).map(blockPos -> level.method_8320(blockPos.method_10084())).orElse(null);
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<DripstoneRecipe> {
        public Serializer() {
            super(DripstoneRecipe::new);
        }

        @Override
        public void fromJson(DripstoneRecipe pRecipe, JsonObject pSerializedRecipe) {
            pRecipe.sourceBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("source_block"));
            pRecipe.targetBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("target_block"));
            if (!pRecipe.ghost) {
                Preconditions.checkArgument((pRecipe.sourceBlock != class_4550.field_20692 ? 1 : 0) != 0, (Object)"source_block can't be wildcard");
                Preconditions.checkArgument((pRecipe.targetBlock != class_4550.field_20692 ? 1 : 0) != 0, (Object)"target_block can't be wildcard");
            }
        }

        @Override
        public void fromNetwork(DripstoneRecipe pRecipe, class_2540 pBuffer) {
            pRecipe.sourceBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pRecipe.targetBlock = BlockPredicateHelper.fromNetwork(pBuffer);
        }

        @Override
        public void toNetwork0(class_2540 pBuffer, DripstoneRecipe pRecipe) {
            BlockPredicateHelper.toNetwork(pRecipe.sourceBlock, pBuffer);
            BlockPredicateHelper.toNetwork(pRecipe.targetBlock, pBuffer);
        }
    }
}

