/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers;

import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.Lists;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MerchantMarkersConfig {
    public static final ForgeConfigSpec SPEC;
    public static final MerchantMarkersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue alwaysShow;
    public final ForgeConfigSpec.BooleanValue showThroughWalls;
    public final ForgeConfigSpec.BooleanValue showArrow;
    public final ForgeConfigSpec.BooleanValue showOnMiniMap;
    public final ForgeConfigSpec.IntValue overlayIndex;
    public final ForgeConfigSpec.DoubleValue opacity;
    public final ForgeConfigSpec.DoubleValue maxDistance;
    public final ForgeConfigSpec.DoubleValue fadePercent;
    public final ForgeConfigSpec.DoubleValue iconScale;
    public final ForgeConfigSpec.DoubleValue minimapIconScale;
    public final ForgeConfigSpec.IntValue verticalOffset;
    public final ForgeConfigSpec.ConfigValue<? extends String> markerType;
    public final ForgeConfigSpec.ConfigValue<Config> associatedItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> professionBlacklist;
    private static Map<String, String> defaultAssociatedItems;

    public MerchantMarkersConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.alwaysShow = build.comment(" If markers above villagers should always show. If false, they will only show when the configured keybind is held.").define("always_show", true);
        this.showThroughWalls = build.comment(" If markers should be visible through walls and other obstructions.").define("show_through_walls", true);
        this.showArrow = build.comment(" If markers should include an arrow under the profession-specific icon.").define("show_arrow", true);
        this.showOnMiniMap = build.comment(" If icons should show on minimaps. (Currently supports Xaero's Minimap, FTB Chunks, and JourneyMap).").define("show_on_minimap", true);
        this.overlayIndex = build.comment(" Which overlay graphic to use (0 = backpack, 1 = emerald, 2 = coin stack, 3 = bag, 4 = profession level, -1 = none).").defineInRange("overlay_icon", 3, -1, 4);
        this.opacity = build.comment(" The opacity of displayed markers and arrows.").defineInRange("opacity", 1.0, 0.1, 1.0);
        this.maxDistance = build.comment(" The maximum distance, in blocks, at which markers are visible.").defineInRange("max_distance", 64.0, 16.0, 256.0);
        this.fadePercent = build.comment(" The percent of the maximum distance at which markers will begin to fade out.").defineInRange("fade_percent", 25.0, 0.0, 100.0);
        this.iconScale = build.comment(" How large in-world markers should appear.").defineInRange("icon_scale", 1.0, 0.5, 2.0);
        this.minimapIconScale = build.comment(" How large markers should appear on minimaps. (Only applicable for maps without a built-in icon scale option.)").defineInRange("minimap_icon_scale", 0.75, 0.5, 2.0);
        this.verticalOffset = build.comment(" How high above villagers markers should appear.  The default position (0) is right above name plates.").defineInRange("vertical_offset", 0, -128, 128);
        this.markerType = build.comment(" The types of markers to show above villagers.  Can be one of either \"items\", \"jobs\", \"generic\", or \"custom\".  These options mean:\n    \"items\" - Shows items from the associated item list below.\n    \"jobs\" - Shows the texture from the villager's job site block (like the brewing stand for clerics, and so on).\n    \"generic\" - Shows a generic icon that is the same for all villagers.\n    \"custom\" - Shows custom icons for each villager profession (these can be replaced with a resource pack).").defineInList("marker_type", (Object)"custom", Arrays.stream(MarkerType.values()).map(v -> v.name().toLowerCase()).toList());
        this.professionBlacklist = build.comment(" A list of professions to ignore when displaying markers. Use \"none\" for villagers with no profession.").define("profession_blacklist", (Object)Lists.newArrayList((Object[])new String[]{"none", "nitwit"}));
        this.associatedItems = build.comment(" The items associated with each villager profession.  Only used when marker type is set to \"items\".\n If not specified here, vanilla professions will have a default item and modded professions will have a generic icon.").define("associated_items", (Object)Config.of((ConfigFormat)TomlFormat.instance()), v -> MerchantMarkersConfig.validateAssociatedItems((Config)v));
        build.pop().pop();
        ModConfigEvents.reloading((String)"merchantmarkers").register(MerchantMarkersConfig::onLoad);
    }

    public boolean showLevels() {
        return OverlayType.LEVEL.equals(OverlayType.fromValue((Integer)this.overlayIndex.get()).orElse(null));
    }

    public class_2960 getAssociatedItem(String profession) {
        Map configuredItems = ((Config)this.associatedItems.get()).valueMap();
        if (configuredItems.containsKey(profession) && configuredItems.get(profession) instanceof String && class_2960.method_20207((String)((String)configuredItems.get(profession)))) {
            return new class_2960((String)configuredItems.get(profession));
        }
        if (defaultAssociatedItems.containsKey(profession)) {
            return new class_2960(defaultAssociatedItems.get(profession));
        }
        return null;
    }

    private static boolean validateAssociatedItems(Config v) {
        if (v == null || v.valueMap() == null) {
            return false;
        }
        for (String key : v.valueMap().keySet()) {
            Object value = v.valueMap().get(key);
            if (value instanceof String && class_2960.method_20207((String)((String)value))) continue;
            Loader.LOGGER.warn("Invalid associated item found: \"{}\".  This value was ignored.", value);
        }
        return true;
    }

    public static void onLoad(ModConfig config) {
        if (config.getModId().equals("merchantmarkers")) {
            Markers.clearResourceCache();
            try {
                if (FabricLoader.getInstance().isModLoaded("xaerominimap")) {
                    Class.forName("com.anthonyhilyard.merchantmarkers.compat.XaeroMinimapHandler").getMethod("clearIconCache", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    static {
        defaultAssociatedItems = new LinkedHashMap<String, String>(Map.ofEntries(Map.entry("armorer", "minecraft:iron_chestplate"), Map.entry("butcher", "minecraft:beef"), Map.entry("cartographer", "minecraft:compass"), Map.entry("cleric", "minecraft:rotten_flesh"), Map.entry("farmer", "minecraft:wheat"), Map.entry("fisherman", "minecraft:cod"), Map.entry("fletcher", "minecraft:bow"), Map.entry("leatherworker", "minecraft:leather"), Map.entry("librarian", "minecraft:bookshelf"), Map.entry("mason", "minecraft:brick"), Map.entry("shepherd", "minecraft:shears"), Map.entry("toolsmith", "minecraft:iron_pickaxe"), Map.entry("weaponsmith", "minecraft:iron_sword"), Map.entry("wandering_trader", "minecraft:emerald")));
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(MerchantMarkersConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (MerchantMarkersConfig)specPair.getLeft();
    }

    public static enum MarkerType {
        ITEMS,
        JOBS,
        GENERIC,
        CUSTOM;


        public static Optional<MarkerType> fromText(String text) {
            return Arrays.stream(MarkerType.values()).filter(v -> v.name().equalsIgnoreCase(text)).findFirst();
        }
    }

    public static enum OverlayType {
        NONE(-1),
        BACKPACK(0),
        EMERALD(1),
        COINS(2),
        BAG(3),
        LEVEL(4);

        private final int value;

        private OverlayType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Optional<OverlayType> fromValue(int value) {
            return Arrays.stream(OverlayType.values()).filter(v -> v.value == value).findFirst();
        }
    }
}

