/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityMapIcon;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_6861;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FTBChunksHandler
implements class_4013 {
    private static FTBChunksHandler INSTANCE = new FTBChunksHandler();
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");
    private static class_1297 currentEntity = null;
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    public static final class_2960 villagerTexture = new class_2960("ftbchunks", "textures/faces/minecraft/villager.png");
    private static Supplier<InputStream> defaultVillagerResource = null;
    private static MethodHandle getEntity = null;

    public static class_1297 getEntityFromIcon(EntityMapIcon icon) {
        try {
            if (getEntity == null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Field entityField = EntityMapIcon.class.getDeclaredField("entity");
                entityField.setAccessible(true);
                getEntity = lookup.unreflectGetter(entityField);
            }
            return getEntity.invoke(icon);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void setCurrentEntity(class_1297 entity) {
        class_310 minecraft;
        class_1060 textureManager;
        currentEntity = entity;
        if (Markers.shouldShowMarker(entity) && (textureManager = (minecraft = class_310.method_1551()).method_1531()).method_34590(villagerTexture, null) != null) {
            minecraft.method_19537(() -> {
                textureManager.method_4615(villagerTexture);
                textureManager.field_5286.remove(villagerTexture);
            });
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        FTBChunksHandler.setupDynamicIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        int innerSize;
        Markers.MarkerResource resource = resourceSupplier.get();
        if (resource == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconCache.containsKey(resource)) {
            return new ByteArrayInputStream(iconCache.get(resource));
        }
        int outerSize = innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
        class_3300 manager = class_310.method_1551().method_1478();
        BufferedImage newImage = new BufferedImage(outerSize, outerSize, 2);
        Graphics2D graphics = newImage.createGraphics();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (manager.method_14486(resource.texture()).isEmpty() && class_310.method_1551().method_1531().method_4619(resource.texture()) == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconOverlayImage == null) {
            iconOverlayImage = ImageIO.read(((class_3298)manager.method_14486(Markers.ICON_OVERLAY).get()).method_14482());
        }
        if (numberOverlayImage == null) {
            numberOverlayImage = ImageIO.read(((class_3298)manager.method_14486(Markers.NUMBER_OVERLAY).get()).method_14482());
        }
        BufferedImage originalImage = ImageIO.read(((class_3298)manager.method_14486(resource.texture()).get()).method_14482());
        int left = (outerSize - innerSize) / 2;
        int right = (outerSize + innerSize) / 2;
        int top = (outerSize + innerSize) / 2;
        int bottom = (outerSize - innerSize) / 2;
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
        graphics.transform(at);
        graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
            float scale = (float)innerSize / (float)originalImage.getWidth();
            graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
        });
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)newImage, "png", os);
            iconCache.put(resource, os.toByteArray());
            byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                iconCache.put(resource, new byte[0]);
                return Markers.getEmptyInputStream();
            }
        }
        os.close();
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        class_310 minecraft = class_310.method_1551();
        class_3300 manager = minecraft.method_1478();
        if (manager instanceof class_3304) {
            class_3298 resource2;
            class_3304 reloadableManager = (class_3304)manager;
            if (!reloadableManager.field_17935.contains(INSTANCE)) {
                reloadableManager.field_17935.add(0, INSTANCE);
            }
            if (defaultVillagerResource == null) {
                try {
                    for (class_3298 resource2 : reloadableManager.method_14489(villagerTexture)) {
                        if (resource2.method_14480().contentEquals("dynamicicons")) continue;
                        byte[] defaultVillagerBytes = IOUtils.toByteArray((InputStream)resource2.method_14482());
                        defaultVillagerResource = () -> new ByteArrayInputStream(defaultVillagerBytes);
                        break;
                    }
                }
                catch (Exception e) {
                    Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            dynamicPack.registerResource(class_3264.field_14188, villagerTexture, () -> {
                if (currentEntity == null || !Markers.shouldShowMarker(currentEntity)) {
                    return Markers.getEmptyInputStream();
                }
                try {
                    String profession = Markers.getProfessionName(currentEntity);
                    int level = Markers.getProfessionLevel(currentEntity);
                    if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
                        return defaultVillagerResource == null ? Markers.getEmptyInputStream() : defaultVillagerResource.get();
                    }
                    InputStream proxyStream = FTBChunksHandler.getResizedIcon(() -> Markers.getMarkerResource(minecraft, profession, level));
                    Thread.sleep(1L);
                    if (proxyStream.available() == 0) {
                        return ((class_3298)reloadableManager.method_14486(Markers.getMarkerResource(minecraft, profession, level).texture()).get()).method_14482();
                    }
                    return proxyStream;
                }
                catch (Exception e) {
                    Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    return Markers.getEmptyInputStream();
                }
            });
            if (!reloadableManager.method_29213().anyMatch(pack -> pack.equals(dynamicPack)) && (resource2 = reloadableManager.field_36391) instanceof class_6861) {
                class_6861 resourceManager = (class_6861)resource2;
                try {
                    reloadableManager.field_36391.close();
                }
                catch (ConcurrentModificationException e) {
                    Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                reloadableManager.field_36391 = new class_6861(reloadableManager.field_14294, Stream.concat(resourceManager.method_29213(), Stream.of(dynamicPack)).toList());
            }
        }
    }

    public void method_14491(class_3300 resourceManager) {
        Markers.clearResourceCache();
        FTBChunksHandler.clearIconCache();
    }
}

