/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_6860;
import net.minecraft.class_6861;
import net.minecraft.class_897;
import org.apache.commons.lang3.exception.ExceptionUtils;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.minimap.XaeroMinimap;

public class XaeroMinimapHandler
implements class_4013 {
    private static XaeroMinimapHandler INSTANCE = new XaeroMinimapHandler();
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");

    public static void buildVariantIdString(StringBuilder stringBuilder, class_897<?> entityRenderer, class_1297 entity) {
        String profession = Markers.getProfessionName(entity);
        int professionLevel = Markers.getProfessionLevel(entity);
        if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
            EntityIconDefinitions.buildVariantIdString((StringBuilder)stringBuilder, entityRenderer, (class_1297)entity);
        } else {
            stringBuilder.append(profession).append("-").append(professionLevel);
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        XaeroMinimapHandler.setupDynamicIcons();
        if (XaeroMinimap.instance != null && XaeroMinimap.instance.getInterfaces() != null) {
            XaeroMinimap.instance.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        block13: {
            Markers.MarkerResource resource = resourceSupplier.get();
            if (resource == null) {
                return Markers.getEmptyInputStream();
            }
            if (iconCache.containsKey(resource)) {
                return new ByteArrayInputStream(iconCache.get(resource));
            }
            int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
            int outerSize = 64;
            class_3300 manager = class_310.method_1551().method_1478();
            BufferedImage newImage = new BufferedImage(64, 64, 2);
            Graphics2D graphics = newImage.createGraphics();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (manager.method_14486(resource.texture()).isEmpty() && class_310.method_1551().method_1531().method_34590(resource.texture(), null) == null) {
                return Markers.getEmptyInputStream();
            }
            if (iconOverlayImage == null) {
                iconOverlayImage = ImageIO.read(((class_3298)manager.method_14486(Markers.ICON_OVERLAY).get()).method_14482());
            }
            if (numberOverlayImage == null) {
                numberOverlayImage = ImageIO.read(((class_3298)manager.method_14486(Markers.NUMBER_OVERLAY).get()).method_14482());
            }
            BufferedImage originalImage = ImageIO.read(((class_3298)manager.method_14486(resource.texture()).get()).method_14482());
            int left = (64 - innerSize) / 2;
            int right = (64 + innerSize) / 2;
            int top = (64 + innerSize) / 2;
            int bottom = (64 - innerSize) / 2;
            graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
            Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
                BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
                float scale = (float)innerSize / (float)originalImage.getWidth();
                graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
            });
            graphics.dispose();
            ByteArrayOutputStream byteArrayOutputStream = os;
            try {
                ImageIO.write((RenderedImage)newImage, "png", os);
                iconCache.put(resource, os.toByteArray());
                byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
                if (byteArrayOutputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    iconCache.put(resource, new byte[0]);
                    return Markers.getEmptyInputStream();
                }
            }
            byteArrayOutputStream.close();
        }
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        class_310 minecraft = class_310.method_1551();
        class_3300 manager = minecraft.method_1478();
        if (manager instanceof class_3304) {
            class_6860 class_68602;
            class_3304 reloadableManager = (class_3304)manager;
            Supplier<Collection> delayedResources = () -> reloadableManager.method_14488("textures/entity/villager/markers", s -> s.toString().endsWith(".png")).keySet();
            if (!reloadableManager.field_17935.contains(INSTANCE)) {
                reloadableManager.field_17935.add(0, INSTANCE);
            }
            if (((Boolean)MerchantMarkersConfig.INSTANCE.showOnMiniMap.get()).booleanValue()) {
                int minLevel;
                int maxLevel;
                if (!MerchantMarkersConfig.INSTANCE.showLevels()) {
                    maxLevel = 0;
                    minLevel = 0;
                } else {
                    minLevel = 0;
                    maxLevel = 15;
                }
                dynamicPack.registerResource(class_3264.field_14188, new class_2960("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    for (class_2960 marker : (Collection)delayedResources.get()) {
                        for (int i = minLevel; i <= maxLevel; ++i) {
                            String[] components = marker.method_12832().split("/");
                            String iconName = components[components.length - 1].replace(".png", "");
                            variants.addProperty(iconName + "-" + String.valueOf(i), "sprite:" + marker.method_12832().replace(".png", "-" + String.valueOf(i) + ".png"));
                        }
                    }
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "com.anthonyhilyard.merchantmarkers.compat.XaeroMinimapHandler.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
                for (class_2960 marker : delayedResources.get()) {
                    String[] components = marker.method_12832().split("/");
                    String iconName = components[components.length - 1].replace(".png", "");
                    for (int i = minLevel; i <= maxLevel; ++i) {
                        int level = i;
                        class_2960 markerLocation = new class_2960("xaerominimap", "entity/icon/sprite/" + marker.method_12832().replace(".png", "-" + String.valueOf(i) + ".png"));
                        if (minecraft.method_1531().method_34590(markerLocation, null) != null) {
                            minecraft.execute(() -> minecraft.method_1531().method_4615(markerLocation));
                        }
                        dynamicPack.registerResource(class_3264.field_14188, markerLocation, () -> {
                            try {
                                InputStream proxyStream = XaeroMinimapHandler.getResizedIcon(() -> Markers.getMarkerResource(minecraft, iconName, level));
                                if (proxyStream.available() == 0) {
                                    return ((class_3298)reloadableManager.method_14486(Markers.getMarkerResource(minecraft, iconName, level).texture()).get()).method_14482();
                                }
                                return proxyStream;
                            }
                            catch (Exception e) {
                                return Markers.getEmptyInputStream();
                            }
                        });
                    }
                }
            } else {
                dynamicPack.registerResource(class_3264.field_14188, new class_2960("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    variants.addProperty("default", "model");
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "xaero.common.minimap.render.radar.EntityIconDefinitions.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
            }
            if (!reloadableManager.method_29213().anyMatch(pack -> pack.equals(dynamicPack)) && (class_68602 = reloadableManager.field_36391) instanceof class_6861) {
                class_6861 resourceManager = (class_6861)class_68602;
                try {
                    reloadableManager.field_36391.close();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                reloadableManager.field_36391 = new class_6861(reloadableManager.field_14294, Stream.concat(resourceManager.method_29213(), Stream.of(dynamicPack)).toList());
            }
        }
    }

    public void method_14491(class_3300 resourceManager) {
        Markers.clearResourceCache();
        XaeroMinimapHandler.clearIconCache();
    }
}

