/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1915;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_3989;
import net.minecraft.class_4158;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Markers {
    public static final class_2960 MARKER_ARROW = new class_2960("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final class_2960 ICON_OVERLAY = new class_2960("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final class_2960 NUMBER_OVERLAY = new class_2960("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final class_2960 DEFAULT_ICON = new class_2960("merchantmarkers", "textures/entity/villager/default.png");
    public static final class_2960 EMPTY_MARKER = new class_2960("merchantmarkers", "textures/entity/villager/empty.png");
    private static Supplier<InputStream> emptyMarkerResource = null;
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static InputStream getEmptyInputStream() {
        if (emptyMarkerResource == null) {
            emptyMarkerResource = () -> {
                class_310 mc = class_310.method_1551();
                class_3300 manager = mc.method_1478();
                try {
                    return ((class_3298)manager.method_14486(EMPTY_MARKER).get()).method_14482();
                }
                catch (Exception e) {
                    return InputStream.nullInputStream();
                }
            };
        }
        return emptyMarkerResource.get();
    }

    public static String getProfessionName(class_1297 entity) {
        String iconName = "";
        if (entity instanceof class_1646) {
            iconName = ((class_1646)entity).method_7231().method_16924().toString().replace(":", "__");
        } else if (entity instanceof class_3989) {
            iconName = "wandering_trader";
        } else if (entity instanceof class_1915) {
            iconName = class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12832();
        } else {
            iconName = class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12832();
            class_310 mc = class_310.method_1551();
            class_3300 manager = mc.method_1478();
            if (!manager.method_14486(new class_2960("merchantmarkers", "textures/entity/villager/markers/" + iconName + ".png")).isPresent()) {
                iconName = "";
            }
        }
        return iconName;
    }

    public static int getProfessionLevel(class_1297 entity) {
        int level = 0;
        if (MerchantMarkersConfig.INSTANCE.showLevels() && entity instanceof class_1646) {
            level = ((class_1646)entity).method_7231().method_16925();
        }
        return level;
    }

    public static void renderMarker(class_897<?> renderer, class_1297 entity, class_2561 component, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (Markers.shouldShowMarker(entity)) {
            double maxDistance;
            class_310 mc = class_310.method_1551();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            double squareDistance = renderer.field_4676.method_23168(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.INSTANCE.maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.INSTANCE.fadePercent.get();
            float currentAlpha = 1.0f;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = (float)class_3532.method_15350((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
                currentAlpha = (float)((double)currentAlpha * (Double)MerchantMarkersConfig.INSTANCE.opacity.get());
            }
            float entityHeight = entity.method_17682() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.INSTANCE.verticalOffset.get()).intValue();
            poseStack.method_22903();
            poseStack.method_22904(0.0, (double)entityHeight, 0.0);
            poseStack.method_22907(renderer.field_4676.method_24197());
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            boolean showArrow = (Boolean)MerchantMarkersConfig.INSTANCE.showArrow.get();
            if (((Boolean)MerchantMarkersConfig.INSTANCE.showThroughWalls.get()).booleanValue()) {
                RenderSystem.disableDepthTest();
                Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, 0.3f * currentAlpha);
                if (showArrow) {
                    Markers.renderArrow(poseStack, 0, y, 0.3f * currentAlpha);
                }
            }
            RenderSystem.enableDepthTest();
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, currentAlpha);
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y, currentAlpha);
            }
            if (depthTestEnabled) {
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.disableDepthTest();
            }
            poseStack.method_22909();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static boolean shouldShowMarker(class_1297 entity) {
        class_1309 livingEntity;
        String professionName = Markers.getProfessionName(entity);
        return professionName != "" && !entity.method_5767() && (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_6109() && !livingEntity.method_29504()) && !((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(professionName);
    }

    public static MarkerResource getMarkerResource(class_310 mc, String professionName, int level) {
        if (professionName == "") {
            return null;
        }
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.INSTANCE.overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.INSTANCE.markerType.get()).get()) {
            case ITEMS: {
                class_2960 associatedItemKey = MerchantMarkersConfig.INSTANCE.getAssociatedItem(professionName);
                if (associatedItemKey == null || !class_7923.field_41178.method_10250(associatedItemKey)) break;
                class_1792 associatedItem = (class_1792)class_7923.field_41178.method_17966(associatedItemKey).get();
                class_918 itemRenderer = mc.method_1480();
                class_1087 bakedModel = itemRenderer.method_4019(new class_1799((class_1935)associatedItem), (class_1937)null, (class_1309)mc.field_1724, 0);
                class_1058 sprite = bakedModel.method_4711();
                class_2960 spriteLocation = new class_2960(sprite.method_45852().method_12836(), String.format("textures/%s%s", sprite.method_45852().method_12832(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                List jobBlockStates;
                class_3852 profession = (class_3852)class_7923.field_41195.method_10223(new class_2960(professionName.replace("__", ":")));
                if (profession == class_3852.field_17051 || (jobBlockStates = class_7923.field_41128.method_42021().stream().map(key -> (class_6880.class_6883)class_7923.field_41128.method_40264(key).get()).filter(poiType -> profession.comp_820().test(poiType)).flatMap(poiType -> ((class_4158)poiType.method_40229().right().get()).comp_815().stream()).distinct().toList()).isEmpty()) break;
                class_776 blockRenderer = mc.method_1541();
                class_1087 bakedModel = blockRenderer.method_3349((class_2680)jobBlockStates.iterator().next());
                class_1058 sprite = bakedModel.method_4711();
                class_2960 spriteLocation = new class_2960(sprite.method_45852().method_12836(), String.format("textures/%s%s", sprite.method_45852().method_12832(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                class_2960 iconResource = new class_2960("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.method_1478().method_14486(iconResource).isPresent()) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, class_4587 poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture(), poseStack, x, y, alpha);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
            float imageSize = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, poseStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize, alpha);
        });
        poseStack.method_22909();
    }

    private static void renderArrow(class_4587 poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        Markers.renderIcon(MARKER_ARROW, poseStack, x - 8, y + 8, 16, 8, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
        poseStack.method_22909();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level();
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay().value() % 2 * 8, resource.overlay().value() / 2 * 8);
    }

    private static void renderIcon(class_2960 icon, class_4587 poseStack, int x, int y, float alpha) {
        Markers.renderIcon(icon, poseStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
    }

    private static void renderIcon(class_2960 icon, class_4587 poseStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1, float alpha) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_310.method_1551().method_1531().method_4619(icon).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)icon);
        RenderSystem.setShader(class_757::method_34543);
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(u0, v1).method_22915(1.0f, 1.0f, 1.0f, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(u1, v1).method_22915(1.0f, 1.0f, 1.0f, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(u1, v0).method_22915(1.0f, 1.0f, 1.0f, alpha).method_1344();
        bufferbuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(u0, v0).method_22915(1.0f, 1.0f, 1.0f, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }

    public record MarkerResource(class_2960 texture, MerchantMarkersConfig.OverlayType overlay, int level) {
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

