/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

public enum WheelScrollDirection {
    NORMAL(0),
    INVERTED(1),
    INVENTORY_POSITION_AWARE(2),
    INVENTORY_POSITION_AWARE_INVERTED(3);

    private final int id;

    private WheelScrollDirection(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public static WheelScrollDirection fromId(int id) {
        if (id == WheelScrollDirection.NORMAL.id) {
            return NORMAL;
        }
        if (id == WheelScrollDirection.INVERTED.id) {
            return INVERTED;
        }
        if (id == WheelScrollDirection.INVENTORY_POSITION_AWARE.id) {
            return INVENTORY_POSITION_AWARE;
        }
        return INVENTORY_POSITION_AWARE_INVERTED;
    }

    public boolean isInverted() {
        return this == INVERTED || this == INVENTORY_POSITION_AWARE_INVERTED;
    }

    public boolean isPositionAware() {
        return this == INVENTORY_POSITION_AWARE || this == INVENTORY_POSITION_AWARE_INVERTED;
    }
}

