/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client;

import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import com.obscuria.obscureapi.client.ExternalData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ExternalTxt
implements ExternalData<List<String>> {
    private final String LINK;
    private final boolean AUTO_UPLOAD;
    private final Consumer<ExternalTxt> CALLBACK;
    private List<String> CONTENT = new ArrayList<String>();
    private boolean uploaded = false;
    @Nullable
    private CompletableFuture<?> future = null;

    private ExternalTxt(String link, boolean autoUpload, Consumer<ExternalTxt> callback) {
        this.LINK = link;
        this.AUTO_UPLOAD = autoUpload;
        this.CALLBACK = callback;
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
    }

    @Contract(value="_ -> new")
    public static ExternalTxt create(String link) {
        return ExternalTxt.create(link, false);
    }

    @Contract(value="_, _ -> new")
    public static ExternalTxt create(String link, boolean autoUpload) {
        return ExternalTxt.create(link, autoUpload, externalFile -> {});
    }

    @Contract(value="_, _, _ -> new")
    public static ExternalTxt create(String link, boolean autoUpload, Consumer<ExternalTxt> callback) {
        return new ExternalTxt(link, autoUpload, callback);
    }

    @Override
    public boolean isInProgress() {
        return this.future != null;
    }

    @Override
    public boolean isUploaded() {
        return this.uploaded;
    }

    @Override
    public List<String> get() {
        if (this.uploaded) {
            return this.CONTENT;
        }
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
        return new ArrayList<String>();
    }

    public ExternalTxt upload() {
        if (this.isInProgress()) {
            return this;
        }
        this.future = CompletableFuture.runAsync(() -> {
            this.CONTENT = ExceptionFilter.getNoNull(new ArrayList(), () -> {
                String line;
                URL url = new URL(this.LINK);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                ArrayList<String> content = new ArrayList<String>();
                while ((line = bufferedReader.readLine()) != null) {
                    content.add(line);
                }
                if (!content.isEmpty()) {
                    this.uploaded = true;
                }
                bufferedReader.close();
                this.future = null;
                return content;
            }, e -> {
                this.future = null;
            });
            if (this.uploaded) {
                this.CALLBACK.accept(this);
            }
        }, class_156.method_18349());
        return this;
    }
}

