/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.config.ClientConfig;
import java.util.stream.IntStream;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class RowCountRenderer {
    private static final class_2960 TINY_NUMBERS_LOCATION = new class_2960("overflowingbars", "textures/font/tiny_numbers.png");

    public static void drawBarRowCount(class_332 guiGraphics, int posX, int posY, int barValue, boolean left, class_327 font) {
        RowCountRenderer.drawBarRowCount(guiGraphics, posX, posY, barValue, left, 20, font);
    }

    public static void drawBarRowCount(class_332 guiGraphics, int posX, int posY, int barValue, boolean left, int maxRowCount, class_327 font) {
        if (barValue <= 0 || maxRowCount <= 0) {
            return;
        }
        float rowCount = (float)barValue / (float)maxRowCount;
        ClientConfig config = (ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class);
        if (!config.rowCount.alwaysRenderRowCount && rowCount <= 1.0f) {
            return;
        }
        int numberValue = config.rowCount.countFullRowsOnly ? class_3532.method_15375((float)rowCount) : class_3532.method_15386((float)rowCount);
        int textColor = config.rowCount.rowCountColor.method_532();
        if (config.rowCount.forceFontRenderer) {
            Object text = String.valueOf(numberValue);
            if (config.rowCount.rowCountX) {
                text = (String)text + "x";
            }
            if (left) {
                posX -= font.method_1727((String)text);
            }
            RowCountRenderer.drawBorderedText(guiGraphics, posX, posY + 1, (String)text, textColor, 255, font);
        } else {
            int[] numberDigitis = IntStream.iterate(numberValue, i -> i > 0, i -> i / 10).map(i -> i % 10).toArray();
            float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(textColor >> 0 & 0xFF) / 255.0f;
            posX = left ? (posX -= config.rowCount.rowCountX ? 7 : 3) : (posX += 4 * numberDigitis.length);
            for (int i2 = 0; i2 < numberDigitis.length; ++i2) {
                RowCountRenderer.drawBorderedSprite(guiGraphics, 3, 5, posX - 4 * i2, posY + 2, 5 * numberDigitis[i2], 0, red, green, blue, 1.0f);
            }
            if (((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).rowCount.rowCountX) {
                RowCountRenderer.drawBorderedSprite(guiGraphics, 3, 5, posX + 4, posY + 2, 0, 7, red, green, blue, 1.0f);
            }
        }
    }

    private static void drawBorderedSprite(class_332 guiGraphics, int width, int height, int posX, int posY, int textureX, int textureY, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        guiGraphics.method_25290(TINY_NUMBERS_LOCATION, posX - 1, posY, (float)textureX, (float)textureY, width, height, 256, 256);
        guiGraphics.method_25290(TINY_NUMBERS_LOCATION, posX + 1, posY, (float)textureX, (float)textureY, width, height, 256, 256);
        guiGraphics.method_25290(TINY_NUMBERS_LOCATION, posX, posY - 1, (float)textureX, (float)textureY, width, height, 256, 256);
        guiGraphics.method_25290(TINY_NUMBERS_LOCATION, posX, posY + 1, (float)textureX, (float)textureY, width, height, 256, 256);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        guiGraphics.method_25290(TINY_NUMBERS_LOCATION, posX, posY, (float)textureX, (float)textureY, width, height, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawBorderedText(class_332 guiGraphics, int posX, int posY, String text, int color, int alpha, class_327 font) {
        guiGraphics.method_51433(font, text, posX - 1, posY, alpha << 24, false);
        guiGraphics.method_51433(font, text, posX + 1, posY, alpha << 24, false);
        guiGraphics.method_51433(font, text, posX, posY - 1, alpha << 24, false);
        guiGraphics.method_51433(font, text, posX, posY + 1, alpha << 24, false);
        guiGraphics.method_51433(font, text, posX, posY, color & 0xFFFFFF | alpha << 24, false);
    }
}

