/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.network.DebugPacket;
import virtuoel.pehkui.network.DebugPayload;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.ConfigSyncUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.NbtCompoundExtensions;
import virtuoel.pehkui.util.ReflectionUtils;
import virtuoel.pehkui.util.VersionUtils;

public class DebugCommand {
    private static final Collection<UUID> MARKED_UUIDS = new HashSet<UUID>();
    private static final Collection<String> MARKED_USERNAMES = new HashSet<String>();
    private static final List<class_1299<? extends class_1297>> TYPES = Arrays.asList(class_1299.field_6051, class_1299.field_6046, class_1299.field_6110, class_1299.field_6099);

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"scale").requires(source -> source.method_9259(2));
        builder.then(class_2170.method_9247((String)"debug").then(ConfigSyncUtils.registerConfigCommands()));
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || PehkuiConfig.COMMON.enableCommands.get().booleanValue()) {
            builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete_scale_data").then(class_2170.method_9247((String)"uuid").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String uuidString = StringArgumentType.getString((CommandContext)context, (String)"uuid");
                try {
                    MARKED_UUIDS.add(UUID.fromString(uuidString));
                }
                catch (IllegalArgumentException e) {
                    ((class_2168)context.getSource()).method_9213(I18nUtils.translate("commands.pehkui.debug.delete.uuid.invalid", "Invalid UUID \"%s\".", uuidString));
                    return 0;
                }
                return 1;
            })))).then(class_2170.method_9247((String)"username").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                MARKED_USERNAMES.add(StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase(Locale.ROOT));
                return 1;
            }))))).then(class_2170.method_9247((String)"garbage_collect").executes(context -> {
                class_2596<class_8705> packet;
                if (VersionUtils.MINOR > 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH >= 5) {
                    packet = ServerPlayNetworking.createS2CPacket((class_8710)new DebugPayload(PacketType.GARBAGE_COLLECT));
                } else {
                    class_2540 buffer = new class_2540(Unpooled.buffer());
                    new DebugPacket(PacketType.GARBAGE_COLLECT).write(buffer);
                    packet = ReflectionUtils.createS2CPacket(Pehkui.DEBUG_PACKET, buffer);
                }
                ReflectionUtils.sendPacket(((class_2168)context.getSource()).method_9207().field_13987, packet);
                System.gc();
                return 1;
            })));
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || PehkuiConfig.COMMON.enableDebugCommands.get().booleanValue()) {
            builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"run_mixin_tests").executes(DebugCommand::runMixinTests))).then(class_2170.method_9247((String)"run_tests").executes(DebugCommand::runTests)));
        }
        commandDispatcher.register(builder);
    }

    public static boolean unmarkEntityForScaleReset(class_1297 entity, class_2487 nbt) {
        if (entity instanceof class_1657 && MARKED_USERNAMES.remove(((class_1657)entity).method_7334().getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        NbtCompoundExtensions compound = (NbtCompoundExtensions)nbt;
        return compound.pehkui_containsUuid("UUID") && MARKED_UUIDS.remove(compound.pehkui_getUuid("UUID"));
    }

    private static int runTests(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = ((class_2168)context.getSource()).method_9229();
        class_2350 dir = entity.method_5735();
        class_2350 opposite = dir.method_10153();
        class_2350 left = dir.method_10160();
        class_2350 right = dir.method_10170();
        int distance = 4;
        int spacing = 2;
        int width = (TYPES.size() - 1) * (spacing + 1) + 1;
        class_243 pos = entity.method_19538();
        class_2338.class_2339 mut = new class_2338.class_2339(pos.field_1352, pos.field_1351, pos.field_1350).method_10104(dir, distance).method_10104(left, width / 2);
        class_1937 w = entity.method_5770();
        for (class_1299<? extends class_1297> t : TYPES) {
            w.method_8501((class_2338)mut, class_2246.field_10093.method_9564());
            class_1297 e = t.method_5883(w);
            e.method_5641((double)mut.method_10263() + 0.5, (double)(mut.method_10264() + 1), (double)mut.method_10260() + 0.5, opposite.method_10144(), 0.0f);
            e.method_5808((double)mut.method_10263() + 0.5, (double)(mut.method_10264() + 1), (double)mut.method_10260() + 0.5, opposite.method_10144(), 0.0f);
            e.method_5847(opposite.method_10144());
            e.method_5780("pehkui");
            w.method_8649(e);
            mut.method_10104(right, spacing + 1);
        }
        int successes = -1;
        int total = -1;
        CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.test.success", "Tests succeeded: %d/%d", successes, total), false);
        return 1;
    }

    private static int runMixinTests(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 executor = ((class_2168)context.getSource()).method_9228();
        if (executor instanceof class_3222) {
            class_2596<class_8705> packet;
            if (VersionUtils.MINOR > 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH >= 5) {
                packet = ServerPlayNetworking.createS2CPacket((class_8710)new DebugPayload(PacketType.MIXIN_AUDIT));
            } else {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                new DebugPacket(PacketType.MIXIN_AUDIT).write(buffer);
                packet = ReflectionUtils.createS2CPacket(Pehkui.DEBUG_PACKET, buffer);
            }
            ReflectionUtils.sendPacket(((class_3222)executor).field_13987, packet);
        }
        CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.start", "Starting Mixin environment audit..."), false);
        MixinEnvironment.getCurrentEnvironment().audit();
        CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.end", "Mixin environment audit complete!"), false);
        return 1;
    }

    public static enum PacketType {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

