/*
 * Decompiled with CFR 0.152.
 */
package io.github.uhq_games.regions_unexplored.world.level.block.other;

import io.github.uhq_games.regions_unexplored.block.RuBlocks;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends class_2248
implements class_3737 {
    public static final class_2753 TIP_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 TIP_SHAPE_UP = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public IcicleBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return IcicleBlock.isValidPointedDripstonePlacement(level, pos, (class_2350)state.method_11654((class_2769)TIP_DIRECTION));
    }

    public class_2680 method_9559(class_2680 state1, class_2350 direction, class_2680 state, class_1936 level, class_2338 pos, class_2338 pos1) {
        if (((Boolean)state1.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state1;
        }
        class_2350 direction1 = (class_2350)state1.method_11654((class_2769)TIP_DIRECTION);
        if (direction1 == class_2350.field_11033 && level.method_8397().method_8674(pos, (Object)this)) {
            return state1;
        }
        if (direction == direction1.method_10153() && !this.method_9558(state1, (class_4538)level, pos)) {
            if (direction1 == class_2350.field_11033) {
                level.method_39279(pos, (class_2248)this, 2);
            } else {
                level.method_39279(pos, (class_2248)this, 1);
            }
            return state1;
        }
        boolean flag = state1.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 dripstonethickness = IcicleBlock.calculateDripstoneThickness((class_4538)level, pos, direction1, flag);
        return (class_2680)state1.method_11657(THICKNESS, (Comparable)dripstonethickness);
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hitResult, class_1676 projectile) {
        class_2338 blockpos = hitResult.method_17777();
        if (!level.field_9236 && projectile.method_36971(level, blockpos) && projectile instanceof class_1685 && projectile.method_18798().method_1033() > 0.6) {
            level.method_22352(blockpos, true);
        }
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float v) {
        if (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
            entity.method_5747(v + 2.0f, 2.0f, level.method_48963().method_48837());
        } else {
            super.method_9554(level, state, pos, entity, v);
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        float f;
        if (IcicleBlock.canDrip(state) && !((f = random.method_43057()) > 0.12f)) {
            IcicleBlock.getFluidAboveStalactite(level, pos, state).filter(p_221848_ -> f < 0.02f || IcicleBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> IcicleBlock.spawnDripParticle(level, pos, state, p_221881_.fluid));
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, (class_4538)level, pos)) {
            level.method_22352(pos, true);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction;
        class_2338 blockpos;
        class_1937 levelaccessor = context.method_8045();
        class_2350 direction1 = IcicleBlock.calculateTipDirection((class_4538)levelaccessor, blockpos = context.method_8037(), direction = context.method_32760().method_10153());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.method_8046();
        class_5691 dripstonethickness = IcicleBlock.calculateDripstoneThickness((class_4538)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)direction1)).method_11657(THICKNESS, (Comparable)dripstonethickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.method_8316(blockpos).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9571(class_2680 state, class_1922 getter, class_2338 pos) {
        return class_259.method_1073();
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 collisionContext) {
        class_5691 dripstonethickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelshape = dripstonethickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (dripstonethickness == class_5691.field_28065 ? (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11033 ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == class_5691.field_28066 ? FRUSTUM_SHAPE : (dripstonethickness == class_5691.field_28067 ? MIDDLE_SHAPE : BASE_SHAPE)));
        class_243 vec3 = state.method_26226(getter, pos);
        return voxelshape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public boolean method_37403(class_2680 state, class_1922 getter, class_2338 pos) {
        return false;
    }

    public float method_32913() {
        return 0.125f;
    }

    private static void spawnDripParticle(class_1937 level, class_2338 pos, class_2680 state, class_3611 fluid) {
        class_243 vec3 = state.method_26226((class_1922)level, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.method_10263() + 0.5 + vec3.field_1352;
        double d2 = (double)((float)(pos.method_10264() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.method_10260() + 0.5 + vec3.field_1350;
        class_3611 fluid1 = IcicleBlock.getDripFluid(level, fluid);
        class_2400 particleoptions = fluid1.method_15791(class_3486.field_15518) ? class_2398.field_28076 : class_2398.field_28078;
        level.method_8406((class_2394)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 level, class_2338 pos, class_2350 direction) {
        class_2350 direction1;
        if (IcicleBlock.isValidPointedDripstonePlacement(level, pos, direction)) {
            direction1 = direction;
        } else {
            if (!IcicleBlock.isValidPointedDripstonePlacement(level, pos, direction.method_10153())) {
                return null;
            }
            direction1 = direction.method_10153();
        }
        return direction1;
    }

    private static class_5691 calculateDripstoneThickness(class_4538 level, class_2338 pos, class_2350 direction, boolean bool) {
        class_2350 direction1 = direction.method_10153();
        class_2680 blockState = level.method_8320(pos.method_10093(direction));
        if (IcicleBlock.isPointedDripstoneWithDirection(blockState, direction1)) {
            return !bool && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!IcicleBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 dripstonethickness = (class_5691)blockState.method_11654(THICKNESS);
        if (dripstonethickness != class_5691.field_28065 && dripstonethickness != class_5691.field_28064) {
            class_2680 blockstate1 = level.method_8320(pos.method_10093(direction1));
            return !IcicleBlock.isPointedDripstoneWithDirection(blockstate1, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    public static boolean canDrip(class_2680 state) {
        return IcicleBlock.isStalactite(state) && state.method_11654(THICKNESS) == class_5691.field_28065 && (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    private static Optional<class_2338> findRootBlock(class_1937 level, class_2338 pos, class_2680 state, int i) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> bipredicate = (pos1, state1) -> state1.method_27852(RuBlocks.ICICLE) && state1.method_11654((class_2769)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical((class_1936)level, pos, direction.method_10153().method_10171(), bipredicate, state1 -> !state1.method_27852(RuBlocks.ICICLE), i);
    }

    private static boolean isValidPointedDripstonePlacement(class_4538 level, class_2338 pos, class_2350 direction) {
        class_2338 blockpos = pos.method_10093(direction.method_10153());
        class_2680 blockstate = level.method_8320(blockpos);
        return blockstate.method_26206((class_1922)level, blockpos, direction) || blockstate.method_26164(class_3481.field_15503) || IcicleBlock.isPointedDripstoneWithDirection(blockstate, direction);
    }

    private static boolean isStalactite(class_2680 state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, class_2350.field_11033);
    }

    private static boolean isStalagmite(class_2680 state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, class_2350.field_11036);
    }

    public boolean method_9516(class_2680 state, class_1922 getter, class_2338 pos, class_10 type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(class_2680 state, class_2350 direction) {
        return state.method_27852(RuBlocks.ICICLE) && state.method_11654((class_2769)TIP_DIRECTION) == direction;
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(class_1937 level, class_2338 pos, class_2680 state) {
        return !IcicleBlock.isStalactite(state) ? Optional.empty() : IcicleBlock.findRootBlock(level, pos, state, 11).map(pos1 -> {
            class_2338 blockpos = pos1.method_10084();
            class_2680 blockstate = level.method_8320(blockpos);
            Object fluid = blockstate.method_27852(class_2246.field_37576) && !level.method_8597().comp_644() ? class_3612.field_15910 : level.method_8316(blockpos).method_15772();
            return new FluidInfo(blockpos, (class_3611)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(class_3611 fluid) {
        return fluid == class_3612.field_15908 || fluid == class_3612.field_15910;
    }

    private static class_3611 getDripFluid(class_1937 level, class_3611 fluid) {
        if (fluid.method_15780(class_3612.field_15906)) {
            return level.method_8597().comp_644() ? class_3612.field_15908 : class_3612.field_15910;
        }
        return fluid;
    }

    private static Optional<class_2338> findBlockVertical(class_1936 level, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> biPredicate, Predicate<class_2680> statePredicate, int a) {
        class_2350 direction1 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 blockPos = pos.method_25503();
        for (int i = 1; i < a; ++i) {
            blockPos.method_10098(direction1);
            class_2680 blockstate = level.method_8320((class_2338)blockPos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockPos.method_10062());
            }
            if (!level.method_31601(blockPos.method_10264()) && biPredicate.test((class_2338)blockPos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    record FluidInfo(class_2338 pos, class_3611 fluid, class_2680 state) {
    }
}

