/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.CrosshairVisibility;
import net.minecraft.class_310;
import net.minecraft.class_5498;

public enum Perspective {
    FIRST_PERSON(class_5498.field_26664, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(class_5498.field_26665, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(class_5498.field_26666, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(class_5498.field_26665, CrosshairVisibility.ALWAYS);

    private final class_5498 cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(class_5498 cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public class_5498 getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next(IClientConfig config) {
        Perspective next;
        if (config.replaceDefaultPerspective()) {
            next = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FIRST_PERSON, THIRD_PERSON_BACK -> SHOULDER_SURFING;
                case THIRD_PERSON_FRONT -> FIRST_PERSON;
                case SHOULDER_SURFING -> THIRD_PERSON_FRONT;
            };
        } else {
            next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        }
        switch (next) {
            case FIRST_PERSON: {
                if (!config.isFirstPersonEnabled()) break;
                return FIRST_PERSON;
            }
            case THIRD_PERSON_BACK: {
                if (!config.isThirdPersonBackEnabled()) break;
                return THIRD_PERSON_BACK;
            }
            case THIRD_PERSON_FRONT: {
                if (!config.isThirdPersonFrontEnabled()) break;
                return THIRD_PERSON_FRONT;
            }
            case SHOULDER_SURFING: {
                return SHOULDER_SURFING;
            }
        }
        return next.next(config);
    }

    public boolean isEnabled(IClientConfig config) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FIRST_PERSON -> config.isFirstPersonEnabled();
            case THIRD_PERSON_BACK -> {
                if (config.isThirdPersonBackEnabled() && !config.replaceDefaultPerspective()) {
                    yield true;
                }
                yield false;
            }
            case THIRD_PERSON_FRONT -> config.isThirdPersonFrontEnabled();
            case SHOULDER_SURFING -> true;
        };
    }

    public static Perspective of(class_5498 cameraType, boolean shoulderSurfing) {
        return switch (cameraType) {
            default -> throw new IncompatibleClassChangeError();
            case class_5498.field_26664 -> FIRST_PERSON;
            case class_5498.field_26665 -> {
                if (shoulderSurfing) {
                    yield SHOULDER_SURFING;
                }
                yield THIRD_PERSON_BACK;
            }
            case class_5498.field_26666 -> THIRD_PERSON_FRONT;
        };
    }

    public static Perspective current() {
        return Perspective.of(class_310.method_1551().field_1690.method_31044(), ShoulderSurfing.getInstance().isShoulderSurfing());
    }
}

