/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.fabric;

import com.github.exopandora.shouldersurfing.IPlatform;
import com.github.exopandora.shouldersurfing.compat.Mods;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.Nullable;

public class Platform
implements IPlatform {
    @Override
    @Nullable
    public String getModVersion(Mods mod) {
        return switch (mod) {
            default -> throw new IncompatibleClassChangeError();
            case Mods.CGM, Mods.CURIOS, Mods.EPIC_FIGHT, Mods.MTS, Mods.OCULUS -> null;
            case Mods.COBBLEMON -> Platform.findModVersionForId("cobblemon");
            case Mods.CREATE -> Platform.findModVersionForId("create");
            case Mods.EMF -> Platform.findModVersionForId("entity_model_features");
            case Mods.IRIS -> Platform.findModVersionForId("iris");
            case Mods.SKIN_LAYERS -> Platform.findModVersionForId("skinlayers3d");
            case Mods.THE_ONE_PROBE -> Platform.findModVersionForId("theoneprobe");
            case Mods.TSLAT_ENTITY_STATUS -> Platform.findModVersionForId("tslatentitystatus");
            case Mods.WILDFIRE_GENDER -> Platform.findModVersionForId("wildfire_gender");
        };
    }

    private static String findModVersionForId(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }

    public static Version parseVersionSilent(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static VersionPredicate parseVersionPredicateSilent(String predicate) {
        try {
            return VersionPredicate.parse((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

