/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.integrations.launchers.types;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hypherionmc.simplerpc.enums.LauncherType;
import com.hypherionmc.simplerpc.integrations.launchers.Launcher;
import java.io.File;

public final class Modrinth
implements Launcher {
    private boolean hasLoaded = false;
    private String packName = "Unknown Pack";

    @Override
    public LauncherType getLauncherType() {
        return LauncherType.MODRINTH;
    }

    @Override
    public void tryLoadLauncher() {
        File pack = new File("profile.json");
        if (pack.exists()) {
            String packString = this.readLauncherFile(pack);
            try {
                JsonObject object = ((JsonObject)new Gson().fromJson(packString, JsonObject.class)).getAsJsonObject("metadata");
                this.packName = object.getAsJsonPrimitive("name").getAsString();
                this.hasLoaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    @Override
    public String getLauncherName() {
        return "Modrinth";
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public String getPackIcon() {
        return "modrinth";
    }
}

