/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http.net;

import com.hypherionmc.simplerpc.jodd.http.HttpConnection;
import com.hypherionmc.simplerpc.jodd.http.HttpConnectionProvider;
import com.hypherionmc.simplerpc.jodd.http.HttpException;
import com.hypherionmc.simplerpc.jodd.http.HttpRequest;
import com.hypherionmc.simplerpc.jodd.http.ProxyInfo;
import com.hypherionmc.simplerpc.jodd.http.Sockets;
import com.hypherionmc.simplerpc.jodd.http.net.HTTPProxySocketFactory;
import com.hypherionmc.simplerpc.jodd.http.net.SocketHttpConnection;
import com.hypherionmc.simplerpc.jodd.http.net.SocketHttpSecureConnection;
import com.hypherionmc.simplerpc.jodd.http.net.Socks4ProxySocketFactory;
import com.hypherionmc.simplerpc.jodd.http.net.Socks5ProxySocketFactory;
import com.hypherionmc.simplerpc.jodd.http.net.TrustManagers;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketHttpConnectionProvider
implements HttpConnectionProvider {
    protected ProxyInfo proxy = ProxyInfo.directProxy();
    protected String secureEnabledProtocols = System.getProperty("https.protocols");
    protected String sslProtocol = "TLSv1.1";

    @Override
    public void useProxy(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    public void setSecuredProtocols(String secureEnabledProtocols) {
        this.secureEnabledProtocols = secureEnabledProtocols;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public SocketHttpConnectionProvider setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    @Override
    public HttpConnection createHttpConnection(HttpRequest httpRequest) throws IOException {
        SocketHttpConnection httpConnection;
        boolean https = httpRequest.protocol().equalsIgnoreCase("https");
        if (https) {
            SSLSocket sslSocket = this.createSSLSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout(), httpRequest.trustAllCertificates(), httpRequest.verifyHttpsHost());
            httpConnection = new SocketHttpSecureConnection(sslSocket);
        } else {
            Socket socket = this.createSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout());
            httpConnection = new SocketHttpConnection(socket);
        }
        httpConnection.setTimeout(httpRequest.timeout());
        try {
            httpConnection.init();
        }
        catch (Throwable throwable) {
            httpConnection.close();
            throw new HttpException(throwable);
        }
        return httpConnection;
    }

    protected Socket createSocket(String host, int port, int connectionTimeout) throws IOException {
        SocketFactory socketFactory = this.resolveSocketFactory(this.proxy, false, false, connectionTimeout);
        if (connectionTimeout < 0) {
            return socketFactory.createSocket(host, port);
        }
        Socket socket = socketFactory.createSocket();
        socket.connect(new InetSocketAddress(host, port), connectionTimeout);
        return socket;
    }

    protected SSLSocket createSSLSocket(String host, int port, int connectionTimeout, boolean trustAll, boolean verifyHttpsHost) throws IOException {
        SocketFactory socketFactory = this.resolveSocketFactory(this.proxy, true, trustAll, connectionTimeout);
        Socket socket = connectionTimeout < 0 ? socketFactory.createSocket(host, port) : Sockets.connect(host, port, connectionTimeout);
        SSLSocket sslSocket = socket instanceof SSLSocket ? (SSLSocket)socket : (socketFactory instanceof SSLSocketFactory ? (SSLSocket)((SSLSocketFactory)socketFactory).createSocket(socket, host, port, true) : (SSLSocket)this.getDefaultSSLSocketFactory(trustAll).createSocket(socket, host, port, true));
        if (this.secureEnabledProtocols != null) {
            String[] values = StringUtil.splitc(this.secureEnabledProtocols, ',');
            StringUtil.trimAll(values);
            sslSocket.setEnabledProtocols(values);
        }
        if (verifyHttpsHost) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParams);
        }
        return sslSocket;
    }

    protected SSLSocketFactory getDefaultSSLSocketFactory(boolean trustAllCertificates) throws IOException {
        if (trustAllCertificates) {
            try {
                SSLContext sc = SSLContext.getInstance(this.sslProtocol);
                sc.init(null, TrustManagers.TRUST_ALL_CERTS, new SecureRandom());
                return sc.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    protected SocketFactory resolveSocketFactory(ProxyInfo proxy, boolean ssl, boolean trustAllCertificates, int connectionTimeout) throws IOException {
        switch (proxy.getProxyType()) {
            case NONE: {
                if (ssl) {
                    return this.getDefaultSSLSocketFactory(trustAllCertificates);
                }
                return SocketFactory.getDefault();
            }
            case HTTP: {
                return new HTTPProxySocketFactory(proxy, connectionTimeout);
            }
            case SOCKS4: {
                return new Socks4ProxySocketFactory(proxy, connectionTimeout);
            }
            case SOCKS5: {
                return new Socks5ProxySocketFactory(proxy, connectionTimeout);
            }
        }
        throw new HttpException("Invalid proxy type " + (Object)((Object)proxy.getProxyType()));
    }
}

