/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverterManager;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Converter {
    private static final Converter CONVERTER = new Converter();

    public static Converter get() {
        return CONVERTER;
    }

    public Boolean toBoolean(Object value) {
        TypeConverter<Boolean> tc = TypeConverterManager.get().lookup(Boolean.class);
        return tc.convert(value);
    }

    public Boolean toBoolean(Object value, Boolean defaultValue) {
        Boolean result = this.toBoolean(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean toBooleanValue(Object value, boolean defaultValue) {
        Boolean result = this.toBoolean(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean toBooleanValue(Object value) {
        return this.toBooleanValue(value, false);
    }

    public Integer toInteger(Object value) {
        TypeConverter<Integer> tc = TypeConverterManager.get().lookup(Integer.class);
        return tc.convert(value);
    }

    public Integer toInteger(Object value, Integer defaultValue) {
        Integer result = this.toInteger(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int toIntValue(Object value, int defaultValue) {
        Integer result = this.toInteger(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int toIntValue(Object value) {
        return this.toIntValue(value, 0);
    }

    public Long toLong(Object value) {
        TypeConverter<Long> tc = TypeConverterManager.get().lookup(Long.class);
        return tc.convert(value);
    }

    public Long toLong(Object value, Long defaultValue) {
        Long result = this.toLong(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public long toLongValue(Object value, long defaultValue) {
        Long result = this.toLong(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public long toLongValue(Object value) {
        return this.toLongValue(value, 0L);
    }

    public Float toFloat(Object value) {
        TypeConverter<Float> tc = TypeConverterManager.get().lookup(Float.class);
        return tc.convert(value);
    }

    public Float toFloat(Object value, Float defaultValue) {
        Float result = this.toFloat(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public float toFloatValue(Object value, float defaultValue) {
        Float result = this.toFloat(value);
        if (result == null) {
            return defaultValue;
        }
        return result.floatValue();
    }

    public float toFloatValue(Object value) {
        return this.toFloatValue(value, 0.0f);
    }

    public Double toDouble(Object value) {
        TypeConverter<Double> tc = TypeConverterManager.get().lookup(Double.class);
        return tc.convert(value);
    }

    public Double toDouble(Object value, Double defaultValue) {
        Double result = this.toDouble(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public double toDoubleValue(Object value, double defaultValue) {
        Double result = this.toDouble(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public double toDoubleValue(Object value) {
        return this.toDoubleValue(value, 0.0);
    }

    public Short toShort(Object value) {
        TypeConverter<Short> tc = TypeConverterManager.get().lookup(Short.class);
        return tc.convert(value);
    }

    public Short toShort(Object value, Short defaultValue) {
        Short result = this.toShort(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public short toShortValue(Object value, short defaultValue) {
        Short result = this.toShort(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public short toShortValue(Object value) {
        return this.toShortValue(value, (short)0);
    }

    public Character toCharacter(Object value) {
        TypeConverter<Character> tc = TypeConverterManager.get().lookup(Character.class);
        return tc.convert(value);
    }

    public Character toCharacter(Object value, Character defaultValue) {
        Character result = this.toCharacter(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public char toCharValue(Object value, char defaultValue) {
        Character result = this.toCharacter(value);
        if (result == null) {
            return defaultValue;
        }
        return result.charValue();
    }

    public char toCharValue(Object value) {
        return this.toCharValue(value, '\u0000');
    }

    public Byte toByte(Object value) {
        TypeConverter<Byte> tc = TypeConverterManager.get().lookup(Byte.class);
        return tc.convert(value);
    }

    public Byte toByte(Object value, Byte defaultValue) {
        Byte result = this.toByte(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public byte toByteValue(Object value, byte defaultValue) {
        Byte result = this.toByte(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public byte toByteValue(Object value) {
        return this.toByteValue(value, (byte)0);
    }

    public boolean[] toBooleanArray(Object value) {
        TypeConverter<boolean[]> tc = TypeConverterManager.get().lookup(boolean[].class);
        return tc.convert(value);
    }

    public int[] toIntegerArray(Object value) {
        TypeConverter<int[]> tc = TypeConverterManager.get().lookup(int[].class);
        return tc.convert(value);
    }

    public long[] toLongArray(Object value) {
        TypeConverter<long[]> tc = TypeConverterManager.get().lookup(long[].class);
        return tc.convert(value);
    }

    public float[] toFloatArray(Object value) {
        TypeConverter<float[]> tc = TypeConverterManager.get().lookup(float[].class);
        return tc.convert(value);
    }

    public double[] toDoubleArray(Object value) {
        TypeConverter<double[]> tc = TypeConverterManager.get().lookup(double[].class);
        return tc.convert(value);
    }

    public short[] toShortArray(Object value) {
        TypeConverter<short[]> tc = TypeConverterManager.get().lookup(short[].class);
        return tc.convert(value);
    }

    public char[] toCharacterArray(Object value) {
        TypeConverter<char[]> tc = TypeConverterManager.get().lookup(char[].class);
        return tc.convert(value);
    }

    public String toString(Object value) {
        TypeConverter<String> tc = TypeConverterManager.get().lookup(String.class);
        return tc.convert(value);
    }

    public String toString(Object value, String defaultValue) {
        String result = this.toString(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String[] toStringArray(Object value) {
        TypeConverter<String[]> tc = TypeConverterManager.get().lookup(String[].class);
        return tc.convert(value);
    }

    public Class toClass(Object value) {
        TypeConverter<Class> tc = TypeConverterManager.get().lookup(Class.class);
        return tc.convert(value);
    }

    public Class[] toClassArray(Object value) {
        TypeConverter<Class[]> tc = TypeConverterManager.get().lookup(Class[].class);
        return tc.convert(value);
    }

    public BigInteger toBigInteger(Object value) {
        TypeConverter<BigInteger> tc = TypeConverterManager.get().lookup(BigInteger.class);
        return tc.convert(value);
    }

    public BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        BigInteger result = this.toBigInteger(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public BigDecimal toBigDecimal(Object value) {
        TypeConverter<BigDecimal> tc = TypeConverterManager.get().lookup(BigDecimal.class);
        return tc.convert(value);
    }

    public BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        BigDecimal result = this.toBigDecimal(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }
}

